import {handleActions} from 'redux-actions';
import {combineReducer} from 'redux';

const product = handleActions({
    ['FETCH_PRODUCT_LIST'](state) {
        return {...state, loading: true,};
    },
    ['FETCH_PRODUCT_LIST_SUCCESS'](state, action) {
        return {...state, loading: false, items: action.items, total: action.total};
    },
    ['FETCH_PRODUCT_LIST_FAILED'](state, action) {
        return {...state, err: action.err, loading: false,};
    },
    ['FETCH_PRODUCT_CATES'](state){
        return {...state, loading: true};
    },
    ['FETCH_PRODUCT_CATES_SUCCESS'](state, action){
        return {...state, loading: false, cates: action.cates};
    },
    ['FETCH_PRODUCT_CATES_FAILED'](state, action){
        return {...state, err: action.err, loading: false};
    },
    ['FETCH_PRODUCT_ITEM'](state){
        return {...state, loading: true}
    },
    ['FETCH_PRODUCT_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, item: action.item}
    },
    ['FETCH_PRODUCT_ITEM_FAILED'](state, action){
        return {...state, err: action.err, loading: false}
    },
    ['UPDATE_PRODUCT_ITEM'](state){
        return {...state, loading: true};
    },
    ['UPDATE_PRODUCT_ITEM_SUCCESS'](state){
        return {...state, loading: false};
    },
    ['UPDATE_PRODUCT_ITEM_FAILED'](state, action){
        return {...state, loading: false, err: action.err};
    },
    ['CREATE_PRODUCT_ITEM'](state){
        return {...state, loading: true};
    },
    ['CREATE_PRODUCT_ITEM_SUCCESS'](state, action){
        return {...state, item: action.item, loading: false};
    },
    ['CREATE_PRODUCT_FAILED'](state, action){
        return {...state, loading: false, err: action.err};
    }
}, {
    //cates: [],
    items: [],
    loading: false,
});

export default product;
