import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import {
    formatDateTime,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    handleUpload
} from '../../utils';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';

@connect(state=>({
    loading: state.contract.loading,
    trade: state.contract.trade,
    shipping: state.contract.shipping
}))
@Form.create()
export default class Contract extends Component {

    componentDidMount() {
        const {dispatch, params:{id}} = this.props;
        dispatch({
            type: 'FETCH_CONTRACT_ITEM',
            id
        });
    };


    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.id = this.props.trade.id;
        console.log(data);
        this.props.dispatch({
            type: 'UPDATE_CONTRACT_ITEM',
            data
        });
    }


    render() {

        const {trade, shipping, loading, form:{getFieldProps}, location:{query}} = this.props;

        const header = (<MainHeader breadcrumb={['订单管理', '订单详情', '合同物流']}
                                    title="合同物流详情"/>);

        return (
            <Layout header={header} >
                <Spin spinning={loading}>
                    <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                        <Form.Item label="产品" {...smallFormItemLayout}>
                            <p>{trade && trade.itemTitle}</p>
                        </Form.Item>
                        <Form.Item label="顺丰运单" {...smallFormItemLayout}>
                            <Input placeholder="请填写顺丰运单编号"
                                {...getFieldProps('expressNO', {
                                    initialValue: shipping && shipping.expressNO
                                })}  />
                        </Form.Item>
                        <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                            <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>保存</Button>
                            <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                    style={{marginLeft:'1em'}}>
                                <Icon type="rollback"/>返回
                            </Button>
                        </Form.Item>
                    </Form>
                </Spin>
            </Layout>
        );
    }
}
