import xFetch from './xFetch';
import {serialize} from '../utils';

export async function fetchList(query) {
    return xFetch('/api/products' + '?' + serialize({s:30, ...query}));
}

export async function fetchCates() {
    return xFetch('/api/cates');
}

export async function fetchItem({id}) {
    return xFetch('/api/products/' + id, {
        method: 'GET'
    });
}

export async function updateItem(item){
    return xFetch('/api/products/'+ item.id, {
        method:'PUT',
        body: serialize(item)
    });
}

export async function createItem() {
    return xFetch('/api/products/create');
}
