import xFetch from '../xFetch';
import {serialize} from '../../utils';
// import storage from '../storage';

export async function fetchList(query) {
    return xFetch('/api/admin/authorities' + '?' + serialize({s: 30, ...query}));
}

export async function fetchItem({id}) {
    return xFetch('/api/admin/authorities/' + id);
}

export async function updateItem(item) {
    return xFetch('/api/admin/authorities/' + item.id, {
        method: 'PUT',
        body: serialize(item)
    });
}
export async function createItem(item) {
    return xFetch('/api/admin/authorities', {
        method: 'POST',
        body: serialize(item)
    });
}

export async function deleteItem({id}) {
    return xFetch('/api/admin/authorities/' + id, {
        method: 'DELETE'
    });
}
