// import {handleActions} from 'redux-actions';
// import {combineReducer} from 'redux';
//
// const initState = {
//     items: [],
//     loading: false,
// };
//
// const product = handleActions({
//     ['CLEAR_PRODUCT'](state){
//         return {...initState};
//     },
//     ['FETCH_PRODUCT_LIST'](state) {
//         return {...state, loading: true,};
//     },
//     ['FETCH_PRODUCT_LIST_SUCCESS'](state, action) {
//         return {...state, loading: false, items: action.items, total: action.total};
//     },
//     ['FETCH_PRODUCT_LIST_FAILED'](state, action) {
//         return {...state, err: action.err, loading: false, items: [], total: 0};
//     },
//     ['FETCH_PRODUCT_CATES'](state){
//         return {...state, loading: true};
//     },
//     ['FETCH_PRODUCT_CATES_SUCCESS'](state, action){
//         return {...state, loading: false, cates: action.cates};
//     },
//     ['FETCH_PRODUCT_CATES_FAILED'](state, action){
//         return {...state, err: action.err, loading: false, cates: []};
//     },
//     ['FETCH_PRODUCT_ITEM'](state){
//         return {...state, loading: true}
//     },
//     ['FETCH_PRODUCT_ITEM_SUCCESS'](state, action){
//         return {...state, loading: false, item: action.item}
//     },
//     ['FETCH_PRODUCT_ITEM_FAILED'](state, action){
//         return {...state, err: action.err, loading: false, item: null}
//     },
//
//
//     ['UPDATE_PRODUCT_START'](state){
//         console.log('UPDATE_PRODUCT_START', state);
//         return {...state, isEdit: true}
//     },
//     ['UPDATE_PRODUCT_END'](state){
//         return {...state, isEdit: false}
//     },
//     ['UPDATE_PRODUCT_ITEM'](state){
//         return {...state, loading: true};
//     },
//     ['UPDATE_PRODUCT_ITEM_SUCCESS'](state, action){
//         if (action.item && action.item.commissionAlg && typeof action.item.commissionAlg === 'string') {
//             try {
//                 action.item.commissionAlg = JSON.parse(action.item.commissionAlg);
//             } catch (err) {
//                 console.log('UPDATE_PRODUCT_ITEM_SUCCESS commissionAlg Error:', action.item.commissionAlg);
//             }
//         }
//         if (action.item && action.item.elements && typeof action.item.elements === 'string') {
//             try {
//                 action.item.elements = JSON.parse(action.item.elements);
//             } catch (err) {
//                 console.log('UPDATE_PRODUCT_ITEM_SUCCESS elements Error:', action.item.elements);
//             }
//         }
//         if (action.item && action.item.staffs && typeof action.item.staffs === 'string') {
//             try {
//                 action.item.staffs = JSON.parse(action.item.staffs);
//             } catch (err) {
//                 console.log('UPDATE_PRODUCT_ITEM_SUCCESS staffs Error:', action.item.staffs);
//             }
//         }
//
//         return {...state, loading: false, item: {...state.item, ...action.item}, isEdit: false};
//     },
//     ['UPDATE_PRODUCT_ITEM_FAILED'](state, action){
//         return {...state, loading: false, err: action.err, isEdit: false};
//     },
//
//
//     ['CREATE_PRODUCT_ITEM'](state){
//         return {...state, loading: true};
//     },
//     ['CREATE_PRODUCT_ITEM_SUCCESS'](state, action){
//         return {...state, item: action.item, loading: false};
//     },
//     ['CREATE_PRODUCT_FAILED'](state, action){
//         return {...state, loading: false, err: action.err, item: null};
//     }
// }, {
//     ...initState
// });
//
// export default product;


import {handleActions} from 'redux-actions';
import base, {init, loading, fail, create, clearItem} from './base';

export default handleActions(base('PRODUCT',{
    CREATE_PRODUCT: function (state, action) {
        return loading(clearItem(state));
    },
    CREATE_PRODUCT_SUCCESS: function (state, action) {
        state.isEdit = true;
        return create(state, action)
    },
    FETCH_PRODUCT_CATES: loading,
    FETCH_PRODUCT_CATES_SUCCESS: function (state, action) {
        return {...state, loading: false, cates: action.result};
    },
    FETCH_PRODUCT_CATES:fail,
    EDIT_PRODUCT_SUCCESS: function (state, action) {
        if (action.data && action.data.commissionAlg && typeof action.data.commissionAlg === 'string') {
            try {
                action.data.commissionAlg = JSON.parse(action.data.commissionAlg);
            } catch (err) {
                console.log('UPDATE_PRODUCT_ITEM_SUCCESS commissionAlg Error:', action.data.commissionAlg);
            }
        }
        if (action.data && action.data.elements && typeof action.data.elements === 'string') {
            try {
                action.data.elements = JSON.parse(action.data.elements);
            } catch (err) {
                console.log('UPDATE_PRODUCT_ITEM_SUCCESS elements Error:', action.data.elements);
            }
        }
        if (action.data && action.data.staffs && typeof action.data.staffs === 'string') {
            try {
                action.data.staffs = JSON.parse(action.data.staffs);
            } catch (err) {
                console.log('UPDATE_PRODUCT_ITEM_SUCCESS staffs Error:', action.data.staffs);
            }
        }

        return {...state, loading: false, item: {...state.item, ...action.data}};
    }
}), init());
