import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import {
    formatDateTime,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    handleUpload
} from '../../utils';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation, {DetailOperations} from '../../components/HeaderOperation/HeaderOperation';

@connect(state=>({
    loading: state.contract.loading,
    item: state.contract.item
}))
@Form.create()
export default class Contract extends Component {

    componentDidMount() {
        const {dispatch, params:{id}} = this.props;
        dispatch({
            type: 'FETCH_CONTRACT',
            data:{id}
        });
    };


    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.id = this.props.params.id;
        console.log(data);
        this.props.dispatch({
            type: 'UPDATE_CONTRACT',
            data
        });
    }


    render() {

        const {item, loading, form:{getFieldProps}, location:{query}} = this.props;
        const operation = (
            <HeaderOperation history={this.props.history} buttons={[{key: 'rollback'}]}/>
        );

        const header = (<MainHeader breadcrumb={['订单管理', '订单详情', '合同物流']}
                                    operation={operation}
                                    title="合同物流详情"/>);

        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    <Form horizontal onSubmit={this.handleSubmit.bind(this)} style={{marginTop: 20}}>
                        <Form.Item label="产品" {...smallFormItemLayout}>
                            <p>{item && item.itemTitle || query.title}</p>
                        </Form.Item>
                        <Form.Item label="顺丰运单" {...smallFormItemLayout}>
                            <Input placeholder="请填写顺丰运单编号"
                                   {...getFieldProps('expressNO', {
                                       initialValue: item && item.expressNO
                                   })}  />
                        </Form.Item>
                        <Form.Item {...footerFormSubmitLayout} style={{marginTop: 30}}>
                            <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>保存</Button>
                            <Button onClick={e=> {
                                e.preventDefault();
                                this.props.history.goBack();
                            }}
                                    style={{marginLeft: '1em'}}>
                                <Icon type="rollback"/>返回
                            </Button>
                        </Form.Item>
                    </Form>
                </Spin>
            </Layout>
        );
    }
}
