import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin,
    Breadcrumb
} from 'antd';

import * as ProductForm from '../../components/ProductForm/index';
import HeaderOperation, {DetailOperations} from '../../components/HeaderOperation/HeaderOperation';
import MainHeader from '../../components/MainHeader/MainHeader';
import Layout from '../../components/Layout/Layout';


@connect(state=>({
    cates: state.product.cates,
    product: state.product.item,
    loading: state.product.loading,
    user: state.user,
    isEdit: state.product.isEdit
}))
export default class EditItem extends Component {

    static propTypes = {
        form: PropTypes.object,
        dispatch: PropTypes.func,
        caste: PropTypes.array,
        product: PropTypes.object
    };

    constructor(props, content) {
        super(props, content);
    }


    componentDidMount() {
        const {cates, params:{id}, dispatch} = this.props;

        if (!(cates && cates.length)) {
            this.fetchCates();
        }
        dispatch({
            type: 'CLEAR_PRODUCT_ITEM'
        });
        if(id) {
            this.fetchItem(id);
        }else{
            dispatch({
                type: 'CREATE_PRODUCT'
            });
        }
        console.log('componentDidMount');
    };

    componentWillReceiveProps(nextProps) {
        const {params:{id}, dispatch} = this.props;

        const createPath = '/products/create';
        //从产品详情页面跳转到添加产品页面
        if(this.props.location.pathname !== createPath && nextProps.location.pathname === createPath){
            console.log('从产品详情页面跳转到添加产品页面 CREATE_PRODUCT');
            dispatch({
                type: 'CREATE_PRODUCT'
            });
            return;
        }
        //从产品添加页面跳转到产品详情页面
        if(this.props.location.pathname === createPath && nextProps.location.pathname !== createPath){
            console.log('从产品添加页面跳转到产品详情页面 INIT_PRODUCT and load', nextProps.params.id);
            dispatch({
                type:'CLEAR_PRODUCT_ITEM'
            });
            this.fetchItem(nextProps.params.id);
            return;
        }
        //添加产品成功后跳转到产品详情页面
        if(this.props.location.pathname === createPath && nextProps.product && nextProps.product.id && nextProps.product.status == 1){
            console.log('添加产品成功后跳转到产品详情页面');
            this.props.history.replace('/products/'+ nextProps.product.id);
            return;
        }
    }

    fetchCates() {
        this.props.dispatch({
            type: 'FETCH_PRODUCT_CATES'
        });
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_PRODUCT',
            data:{id}
        });
    };


    render = ()=> {

        const {product, isEdit, params, dispatch} = this.props;

        const isCreate = !params.id;

        const styles = require('./Product.less');

        const tabs = [
            {tab: '基本信息', children: ProductForm.BaseInfoForm},
            {tab: '收益佣金', children: ProductForm.ShouyiYongjingForm},
            {tab: '汇款账号', children: ProductForm.HuikuanInfoForm},
            {tab: '基本要素', children: ProductForm.ElementForm},
            {tab: '时间'+(isCreate ?'':'状态'), children: ProductForm.DateTimeStatusForm},
            {tab: '相关附件', children: ProductForm.DocumentsForm},
            {tab: '服务经理', children: ProductForm.ContactForm}
        ];
        if(isCreate){
            tabs.push({tab: '创建', children: ProductForm.PublishForm});
        }
        //     .map((tabPane, index)=> {
        //     tabPane.key = 'tabs-pane-' + (index + 1);
        //     return tabPane;
        // });

        const title = isCreate ? '添加产品' : ((product && product.itemShortTitle ? product.itemShortTitle + ' - ' : '') + '产品详情' + (isEdit ? ' - 编辑中' : ''));

        const breadcrumb= isCreate ? ['产品管理', '添加产品'] : ['产品管理', '产品详情'];

        const operation = isCreate ? null : (
            <HeaderOperation history={this.props.history}
                             buttons={product && DetailOperations('PRODUCT', params.id, isEdit, dispatch)}/>
        );

        const header = (
            <MainHeader breadcrumb={breadcrumb}
                        title={title}
                        operation={operation}
            />
        );


        return (
            <Layout header={header}>
                <Tabs className={styles.tabs} tabPosition="left">
                    { tabs.map((tp, index)=>
                        <Tabs.TabPane tab={tp.tab} key={'tabs-pane-'+ index}>
                            {product && <tp.children {...this.props} isEdit={isEdit} isCreate={isCreate}/> }
                        </Tabs.TabPane>
                    )}
                </Tabs>
            </Layout>
        );
    }
}
