import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import {
    UUID, NULL,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    handleUpload,
    leftRightFormItemLayout,
    FILE_UPLOAD
} from '../../utils';

import FooterOperation from '../FooterOperation/FooterOperation';


@Form.create()
export default class BaseInfoForm extends Component {

    static propsType = {
        cates: PropTypes.array,
        product: PropTypes.object,
        user: PropTypes.object,
        dispatch: PropTypes.func,
        isCreate: PropTypes.bool,
    };

    constructor(props, context) {
        super(props, context);

        this.state = {
            priviewVisible: false,
            priviewImage: '',
            fileList: [],
        };
    }

    componentDidMount() {
        this.updateStateOfNextProps(this.props);
    }

    updateStateOfNextProps(props) {
        const {product:{itemPic}} = props;

        if (itemPic) {
            this.setState({
                fileList: [{
                    uid: UUID(),
                    status: 'done',
                    url: itemPic,
                    thumbUrl: itemPic + '!t'
                }]
            });
        } else {
            console.log('没有找到商品主图', this.props.product);
        }
    }

    handleSubmit(e) {
        e.preventDefault();
        const {isCreate, form, product, dispatch} = this.props;
        const data = form.getFieldsValue();

        if (Array.isArray(data.categoryId) && data.categoryId.length === 2) {
            data.categoryParentId = data.categoryId[0];
            data.categoryId = data.categoryId[1];
        } else {
            delete data.categoryId;
        }

        if (this.state.fileList && this.state.fileList[0] && this.state.fileList[0].url) {
            data['itemPic'] = this.state.fileList[0].url;
        }

        data.id = product.id;

        console.log('收到表单值：', data);

        dispatch({
            type: isCreate ? 'UPDATE_PRODUCT' : 'EDIT_PRODUCT_SUBMIT',
            data
        });

    };

    render() {
        const {user, cates, product, loading, form:{getFieldProps}, isEdit, isCreate} = this.props;



        let productCate = [];


        if (product && product.categoryId && product.categoryParentId) {
            if (isEdit) {
                productCate = [product.categoryParentId, product.categoryId];
            } else if (cates && cates.length) {
                cates.forEach(cate=> {
                    if (cate.value == product.categoryParentId) {
                        productCate.push(cate.label);
                        cate.children.forEach(child=> {
                            if (child.value == product.categoryId) {
                                productCate.push(child.label);
                            }
                        });
                    }
                });

            }
        }

        const imgProps = (src)=>({
            src: src + '!t',
            style: {maxWidth: 200, maxHeight: 160},
            onClick: e => {
                e.preventDefault();
                this.setState({
                    priviewVisible: true,
                    priviewImage: src
                });
            }
        });


        return (
            <Spin spinning={loading}>
                <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                    <Row style={{padding:'0 20px'}}>
                        <Col span="12">
                            <Form.Item label="产品类目" {...leftRightFormItemLayout}>
                                {
                                    cates && (
                                        isEdit ?
                                            <Cascader options={cates} placeholder="请选产品类目"
                                                {...getFieldProps('categoryId', {
                                                    initialValue: productCate
                                                })}
                                            />
                                            :
                                            (productCate.length ? productCate.join(' / ') : NULL)
                                    )

                                }
                            </Form.Item>
                            <Form.Item label="产品短标题" {...leftRightFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input placeholder="产品短标题"
                                            {...getFieldProps('itemShortTitle', {
                                                initialValue: product.itemShortTitle,
                                            })}
                                        />
                                        :
                                    product.itemShortTitle || NULL
                                }
                            </Form.Item>
                            <Form.Item label="产品标题" {...leftRightFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input placeholder="产品标题"
                                            {...getFieldProps('itemTitle', {
                                                initialValue: product.itemTitle
                                            })}
                                        />
                                        :
                                    product.itemTitle || NULL
                                }

                            </Form.Item>
                            <Form.Item label="产品简介" {...leftRightFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input type="textarea" autosize={{minRows:5, maxRows:20}} placeholder="产品简介"
                                            {...getFieldProps('summary', {
                                                initialValue: product.summary
                                            })}
                                        />
                                        :
                                        (
                                            product.summary ?
                                                <p style={{maxWidth:300, lineHeight:1.732}}>
                                                    {product.summary}
                                                </p>
                                                :
                                                NULL
                                        )
                                }
                            </Form.Item>

                            <Form.Item label="产品主图" {...leftRightFormItemLayout}>
                                {
                                    isEdit ?
                                        <Upload {...FILE_UPLOAD} listType="picture-card"
                                                multiple={true}
                                                headers={{
                                                authorization: user && user.token,
                                            }}
                                                onChange={info=>this.setState({fileList: handleUpload(info, 1)})}
                                                onPreview={file => {
                                                this.setState({
                                                    priviewImage: file.url,
                                                    priviewVisible: true
                                                });
                                            }}
                                                fileList={this.state.fileList}>
                                            <Icon type="upload"/>
                                            <div className="ant-upload-text">上传照片</div>
                                        </Upload>
                                        :
                                        (product.itemPic ? <img {...imgProps(product.itemPic)} /> : NULL)
                                }

                                <Modal footer={null}
                                       width="100vw"
                                       visible={this.state.priviewVisible}
                                       className="img-priview-dialog"
                                       style={{height:'100vh', background:'transparent'}}
                                       onCancel={()=>this.setState({ priviewVisible: false })}>
                                    <img src={this.state.priviewImage} style={{maxWidth:'100%'}}/>
                                </Modal>
                            </Form.Item>
                            <FooterOperation {...this.props} layout={{wrapperCol:{span: 16, offset: 6}}} command="PRODUCT" hasCancel={!isCreate} />
                        </Col>
                        <Col span="12">
                            <Form.Item label="募集目标" help={ isEdit && "本期额度, 可以输入100万, 2亿等"}
                                {...leftRightFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input placeholder="募集目标"
                                            {...getFieldProps('fundRaisedTarget', {
                                                initialValue: product.fundRaisedTarget
                                            })}
                                        />
                                        :
                                    product.fundRaisedTarget || NULL
                                }
                            </Form.Item>
                            <Form.Item label="产品期限" help={isEdit && "例如:半年期"} {...leftRightFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input placeholder="" {...getFieldProps('duration', {
                                            initialValue: product.duration
                                        })} />
                                        :
                                    product.duration || NULL
                                }
                            </Form.Item>
                            <Form.Item label="起投金额" help={isEdit && "最小购买份额"}  {...leftRightFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input placeholder=""
                                            {...getFieldProps('minimumAmount', {
                                                initialValue: product.minimumAmount
                                            })}
                                        />
                                        :
                                    product.minimumAmount || NULL
                                }
                            </Form.Item>
                            <Form.Item label="已预约" help={isEdit && "此处的已预约只用于显示"} {...leftRightFormItemLayout} >
                                {
                                    isEdit ?
                                        (
                                            ((typeof product.fundReservationOver !== 'undefined') && ( product.fundReservationOver !== '')) ?
                                                <div style={{maxWidth:500}}>
                                                    <Input addonAfter={"实际:"+ product.fundReservationOver}
                                                        {...getFieldProps('fundReservationOverFake', {
                                                            initialValue: product.fundReservationOverFake
                                                        })}
                                                    />
                                                </div>
                                                :
                                                <Input
                                                    {...getFieldProps('fundReservationOverFake', {
                                                        initialValue: product.fundReservationOverFake
                                                    })}
                                                />
                                        )
                                        :
                                        <div>
                                            {
                                                product.fundReservationOverFake ? "显示: " + product.fundReservationOverFake : NULL
                                            }
                                            {
                                                product.fundReservationOver &&
                                                <span
                                                    style={{marginLeft:'2em'}}>{" 实际: " + product.fundReservationOver}</span>
                                            }
                                        </div>

                                }
                            </Form.Item>
                            <Form.Item label="已募集" help={isEdit && "此处的已募集只用于显示"} {...leftRightFormItemLayout}>
                                {
                                    isEdit ?
                                        (((typeof product.fundRaisedOver !== 'undefined') && (product.fundRaisedOver !== '')) ?
                                            <div style={{maxWidth:500}}>
                                                <Input addonAfter={"实际:"+ product.fundRaisedOver}
                                                    {...getFieldProps('fundRaisedOverFake', {
                                                        initialValue: product.fundRaisedOverFake
                                                    })}
                                                />
                                            </div>
                                            :
                                            <Input
                                                {...getFieldProps('fundRaisedOverFake', {
                                                    initialValue: product.fundRaisedOverFake
                                                })}
                                            />)
                                        :
                                        <div>
                                            {
                                                product.fundRaisedOverFake ? "显示: " + product.fundRaisedOverFake : NULL
                                            }
                                            {
                                                product.fundReservationOver &&
                                                <span
                                                    style={{marginLeft:'2em'}}>{" 实际: " + product.fundRaisedOverFake}</span>
                                            }
                                        </div>
                                }
                            </Form.Item>
                            <Form.Item label="产品所属公司" {...leftRightFormItemLayout} >
                                {
                                    isEdit ?
                                        <Input placeholder="产品所属公司"
                                            {...getFieldProps('company', {
                                                initialValue: product.company
                                            })}
                                        />
                                        :
                                    product.company || NULL
                                }

                            </Form.Item>
                            <Form.Item label="所属公司网址" {...leftRightFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input placeholder="所属公司网址"
                                            {...getFieldProps('website', {
                                                initialValue: product.website
                                            })}
                                        />
                                        :
                                    product.website || NULL
                                }

                            </Form.Item>
                        </Col>
                    </Row>
                </Form>
            </Spin>
        );
    }
}




