import xFetch from './xFetch';
import {serialize} from '../utils';

export async function fetchList(query) {
    return xFetch('/api/banners' + '?' +serialize({s:30, ...query}));
}

export async function fetchItem(id) {
    return xFetch('/api/banners/' + id);
}

export async function createItem(item) {
    return xFetch('/api/banners', {
        method: 'POST',
        body: serialize(item)
    });
}

export async function updateItem(item){
    return xFetch('/api/banners/'+ item.id, {
        method:'PUT',
        body: serialize(item)
    });
}
