import {handleActions} from 'redux-actions';
import {combineReducer} from 'redux';

const initState = {
    items: [],
    loading: false,
};

const banner = handleActions({
    ['INIT_BANNER'](){
        return initState;
    },
    ['FETCH_BANNER_LIST'](state) {
        return {...state, loading: true,};
    },
    ['FETCH_BANNER_LIST_SUCCESS'](state, action) {
        return {...state, loading: false, items: action.items, total: action.total};
    },
    ['FETCH_BANNER_LIST_FAILED'](state, action) {
        return {...state, err: action.err, loading: false, items: [], total: 0};
    },
    ['FETCH_BANNER_ITEM'](state){
        return {...state, loading: true}
    },
    ['FETCH_BANNER_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, item: action.item}
    },
    ['FETCH_BANNER_ITEM_FAILED'](state, action){
        return {...state, err: action.err, loading: false, item: null}
    },
    ['CREATE_BANNER_ITEM'](state){
        return {...state, loading: true}
    },
    ['CREATE_BANNER_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, item: action.item}
    },
    ['CREATE_BANNER_ITEM_FAILED'](state, action){
        return {...state, err: action.err, loading: false, item: null}
    },
    ['UPDATE_BANNER_START'](state){
        return {...state, isEdit: true}
    },
    ['UPDATE_BANNER_END'](state){
        return {...state, isEdit: false}
    },
    ['UPDATE_BANNER_ITEM'](state){
        return {...state, loading: true}
    },
    ['UPDATE_BANNER_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, isEdit: false, item: {...state.item, ...action.item}}
    },
    ['UPDATE_BANNER_ITEM_FAILED'](state, action){
        return {...state, err: action.err, loading: false, isEdit: false, item: null}
    },
    ['CLEAR_BANNER_ITEM'](state){
        delete state.item;
        return {...state};
    },
    ['UPDATE_BANNER_ITEM_STATUS'](state){
        return {...state, loading:true};
    },
    ['UPDATE_BANNER_ITEM_STATUS_SUCCESS'](state, action){
        for(let item of state.items){
            if(item.id === action.data.id){
                item.status = action.data.status;
                break;
            }
        }
        return {...state, loading:false};
    },
    ['UPDATE_BANNER_ITEM_STATUS_FAILED'](state){
        return {...state, loading:false};
    }
}, initState);

export default banner;
