import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation from '../../components/HeaderOperation/HeaderOperation';

import {
    formatDateTime,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    remittanceAuditStatusToString,
    NULL
} from '../../utils';

@connect(state=>({
    loading: state.withdraw.loading,
    audit: state.withdraw.audit,
}))
@Form.create()
export default class PassItem extends Component {
    constructor() {
        super(...arguments);
        this.state = {
            isEdit: false
        }
    }


    componentDidMount() {
        this.fetchItem(this.props.params.id);
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_WITHDRAW_ITEM',
            id
        });
    };

    handleSubmit(status, e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.id = this.props.params.id;
        data.status = status;
        console.log(data);
        if (status == 9) {
            delete data.memo;
        }
        this.props.dispatch({
            type: 'PASS_WITHDRAW_ITEM',
            data
        });
    }

    render() {
        const {audit, loading, form:{getFieldProps}, location:{query}} = this.props;

        let title = (audit && audit.nickname ? audit.nickname + ' - ' : '');

        const isEdit = audit && audit.status == 1 && this.state.isEdit;


        if (audit) {
            switch (audit.status) {
                case 1:
                    title += '报单审核详情';
                    break;
                case 5:
                    title += '审核失败';
                    break;
                case 9:
                    title += '审核成功';
            }
        } else {
            title += '报单审核详情';
        }

        const buttons = [{
            key: 'rollback',
            onClick: e=> {
                e.preventDefault();
                isEdit ?
                    this.setState({isEdit: !this.state.isEdit}) :
                    this.props.history.goBack();
            }
        }];

        if(audit && audit.status == 1){
            buttons.unshift({
                key:'edit',
                onClick:e=> {
                    e.preventDefault();
                    this.setState({isEdit: !this.state.isEdit})
                }
            });
        }

        const operation = (
            <HeaderOperation history={this.props.history} buttons={buttons}/>
        );



        const header = (
            <MainHeader breadcrumb={['审核管理', '提现审核','审核详情']}
                        title={title}
                        operation={operation}
            />
        );


        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        audit &&
                        <Form horizontal className="main-form">
                            <Row style={{padding:'0 20px'}}>
                                <Col span="12">
                                    <Form.Item label="申请时间" {...smallFormItemLayout}>
                                        {audit.dateCreated && formatDateTime(audit.dateCreated) || '错误的时间'}
                                    </Form.Item>
                                    <Form.Item label="当前余额" {...smallFormItemLayout}>
                                        <span className="money">{audit.balance || NULL}</span>
                                    </Form.Item>
                                    <Form.Item label="持卡人" {...smallFormItemLayout}>
                                        {audit.bankCard && audit.bankCard.username || NULL}
                                    </Form.Item>
                                    <Form.Item label="卡号" {...smallFormItemLayout}>
                                        {audit.bankCard && audit.bankCard.num || NULL}
                                    </Form.Item>
                                    <Form.Item label="银行卡信息" {...smallFormItemLayout}>
                                        {audit.bankCard && audit.bankCard.bank || NULL }
                                        {" - "}
                                        {audit.bankCard && audit.bankCard.bankBranch || NULL}
                                    </Form.Item>
                                    <Form.Item label="提现金额"  {...smallFormItemLayout}>
                                        <span className="money">{audit.amount || NULL}</span>
                                    </Form.Item>
                                    {
                                        audit.status == 5 ?
                                            <Form.Item label="拒绝理由" {...smallFormItemLayout}>
                                                { audit.memo || NULL }
                                            </Form.Item>
                                            :
                                            (
                                                audit.status == 1 && isEdit &&
                                                <Form.Item label="拒绝理由" {...smallFormItemLayout}>
                                                    <Input placeholder="拒绝理由"  type="textarea"
                                                           autosize
                                                        {...getFieldProps('memo', {
                                                            initialValue: ''
                                                        })}  />
                                                </Form.Item>
                                            )
                                    }
                                    <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                                        {
                                            audit.status == 1 && (
                                                isEdit ?
                                                    <span>
                                                        <Button size="large" type="primary"
                                                                onClick={this.handleSubmit.bind(this, 9)}>
                                                            <Icon type="check-circle-o"/>通过
                                                        </Button>
                                                        <Button size="large" type="ghost"
                                                                onClick={this.handleSubmit.bind(this, 5)}
                                                                style={{margin:'auto 1em' }}>
                                                            <Icon type="cross-circle-o"/>拒绝
                                                        </Button>
                                                    </span>
                                                    :
                                                    <Button type="primary"
                                                            style={{marginRight:'1em'}}
                                                            onClick={ e=>{
                                                                    e.preventDefault();
                                                                    this.setState({isEdit: !this.state.isEdit})
                                                            }}>
                                                        <Icon type="edit"/>审核
                                                    </Button>
                                            )
                                        }
                                        <Button onClick={e=>{
                                            e.preventDefault();
                                            isEdit ?
                                                this.setState({isEdit: !this.state.isEdit}) :
                                                this.props.history.goBack();
                                        }}>
                                            <Icon type="rollback"/>
                                            {isEdit?'取消':'返回'}
                                        </Button>
                                    </Form.Item>
                                </Col>
                            </Row>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}
