import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin,
    Popconfirm
} from 'antd';

import {
    formatDateTime,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    handleUpload,
    NULL,
    mobileSecrecy
} from '../../utils';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation, {DetailOperations} from '../../components/HeaderOperation/HeaderOperation';


@connect(state=>({
    item: state.trade.item,
    loading: state.trade.loading
}))
@Form.create()
export default class Commission extends Component {

    componentDidMount() {
        const {dispatch, params:{id}} = this.props;
        dispatch({
            type: 'FETCH_TRADE_ITEM',
            id
        });
    };


    handleSubmit() {
        this.props.dispatch({
            type: 'SETTLEMENT_TRADE_ITEM',
            id: this.props.item.id
        })
    }

    render() {

        const {item, loading, form:{getFieldProps}, location:{query}} = this.props;

        const operation = (
            <HeaderOperation history={this.props.history} buttons={[{key:'rollback'}]}/>
        );

        const header = (<MainHeader breadcrumb={['订单管理', '订单详情', '佣金发放']}
                                    operation={operation}
                                    title={(item && item.shortTitle + ' - ' || '') + '佣金发放'}/>);

        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        item &&
                        <Form className="main-form" horizontal >
                            <Form.Item label="产品" {...smallFormItemLayout}>
                                <p>{item.title || NULL}</p>
                            </Form.Item>
                            <Form.Item label="理财师" {...smallFormItemLayout}>
                                {
                                    item.user ?
                                        ((item.user.username || NULL) + ' - ' +
                                        (mobileSecrecy(item.user.mobile) || NULL))
                                        :
                                        NULL
                                }
                            </Form.Item>
                            <Form.Item label="确认打款金额" {...smallFormItemLayout}>
                                {
                                    item.remittanceAmount || NULL
                                }
                            </Form.Item>
                            <Form.Item label="实际佣金" {...smallFormItemLayout}>
                                {
                                    item.commission || NULL
                                }
                            </Form.Item>
                            <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                                {
                                    (item.status == 11 || item.status == 21) && (! item.commissionId) &&
                                    <Popconfirm title="确定要发放佣金吗？" onConfirm={this.handleSubmit.bind(this)} >
                                        <Button type="primary" size="large" loading={loading}>
                                            <Icon type="save"/>发放
                                        </Button>
                                    </Popconfirm>

                                }
                                <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                        style={{marginLeft:'1em'}}>
                                    <Icon type="rollback"/>返回
                                </Button>
                            </Form.Item>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}


// <div className={styles.trade}>
//     <div className={styles.tradeTable}>
//         <Row type="flex" justify="space-around" align="middle">
//             <Col span={tw}>产品</Col>
//             <Col span={vw}>{item.title}</Col>
//         </Row>
//         <Row type="flex" justify="space-around" align="middle">
//             <Col span={tw}>确认打款金额</Col>
//             <Col span={vw}>{item.remittanceAmount}</Col>
//         </Row>
//
//         <Row type="flex" justify="space-around" align="middle">
//             <Col span={tw}>实际佣金</Col>
//             <Col span={vw}>{item.realReturn && item.realReturn.yj}</Col>
//         </Row>
//     </div>
//     <p>
//         <Button onClick={this.handleGoBack.bind(this)}>返回</Button>
//         {
//             (item.status == 11 || item.status == 21) &&
//             <Button onClick={this.handleCommission.bind(this)}>发放</Button>
//         }
//     </p>
// </div>
