import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Table, Icon, Button, Switch, Form, Modal} from 'antd';
import {serialize, formatDateTime, productStatusToString, footerFormSubmitLayout, imgProps} from '../../utils';
import {Link} from 'react-router';
import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation from '../../components/HeaderOperation/HeaderOperation';


@connect(state=>({
    items: state.banner.items,
    loading: state.banner.loading,
    total: state.banner.total,
}))
export default class List extends Component {

    constructor(props, context) {
        super(props, context);
        this.state = {
            filterVisible: false
        }
    }

    componentDidMount() {
        this.fetchList(this.props.location.query);
    };

    fetchList(query) {
        this.props.dispatch({
            type: 'FETCH_BANNER_LIST',
            query
        });
    };


    handleFilterVisible() {

    }

    render() {

        const {total, items, loading, history, location:{pathname, query}} = this.props;

        const pagination = {
            total: total,
            pageSize: parseInt(query.s, 10) || 30,
            current: parseInt(query.p, 10) || 1,
            showSizeChanger: true,
            showTotal: total => `共 ${total} 条`,
            pageSizeOptions: ['10', '30', '50', '100'],
            onShowSizeChange: (current, pageSize)=> {
                console.log('Current: ', current, '; PageSize: ', pageSize);
                query.p = current;
                query.s = pageSize;
                history.replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            },
            onChange: (current)=> {
                console.log('Current: ', current);
                query.p = current;
                history.replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            }
        };

        const columns = [
            {
                title: 'ID',
                dataIndex: 'id',
                key: 'id',
                width: 60
            }, {
                title: '标题',
                dataIndex: 'title',
                key: 'title',
                width: 150,
            }, {
                title: 'Banner',
                dataIndex: 'pic',
                key: 'pic',
                width: 100,
                className:'tac',
                render: (pic, record)=>(
                    <img {...imgProps(this, pic)} style={{display:'block', margin:'auto'}} />
                )
            },{
                title: '跳转对象',
                dataIndex: 'redirect',
                key: 'redirect',
                width: 200,
            },{
                title: '权重',
                dataIndex: 'weight',
                key: 'weight',
                width: 80,
                className:'tac',
            }, {
                title: '创建时间',
                dataIndex: 'dateCreated',
                key: 'dateCreated',
                width: 150,
                className: 'tac',
                render: (dateCreated, record)=>(
                    <span>
                        {dateCreated && formatDateTime(dateCreated)}
                    </span>
                )
            }, {
                title: '状态',
                dataIndex: 'status',
                key: 'status',
                width: 120,
                className: 'tac',
                render: (status, record)=>(
                    <span onClick={e=> {
                        e.stopPropagation();
                        e.preventDefault();
                    }}>
                        <Switch key={'status-' + record.id} checkedChildren="开" unCheckedChildren="关"
                                checked={!!status}
                                onChange={checked=> {
                                    this.props.dispatch({
                                        type: 'UPDATE_BANNER_ITEM_STATUS',
                                        data: {
                                            id: record.id,
                                            status: checked ? 1 : 0
                                        }
                                    })
                                }}
                        />
                    </span>
                )
            }
        ];

        const buttons = [{
            key: 'add',
            link: '/banners/create',
            onClick: ()=> {}
        }, {
            key: 'filter',
        }, {
            key: 'rollback'
        }];

        const operation = (
            <HeaderOperation history={history} buttons={buttons}/>
        );

        const header = (
            <MainHeader breadcrumb={['Banner管理', 'Banner列表']}
                        title={(query.title ? query.title + ' - ' : '') + 'Banner列表'}
                        operation={operation}
            />
        );

        return (
            <Layout header={header}>
                <Table className="list-table" columns={columns}
                       dataSource={Array.isArray(items) ? items : []}
                       loading={loading}
                       pagination={pagination}
                       scroll={{y: window.innerHeight - (this.state.filterVisible ? 203 : 150)}}
                       onRowClick={({id})=> {
                           history.push('/banners/' + id);
                       }}
                       rowKey="id"
                       key="banner-list"
                />
                <Modal footer={null}
                       width="100vw"
                       visible={this.state.priviewVisible}
                       className="img-priview-dialog"
                       style={{height:'100vh', background:'transparent'}}
                       onCancel={()=>this.setState({ priviewVisible: false })}>
                    <img src={this.state.priviewImage} style={{maxWidth:'100%'}}/>
                </Modal>
            </Layout>
        );
    }
}
