import "./news.less";
import $ from "jquery";

import "./news.html";

import "babel-plugin-transform-es3-member-expression-literals";
import "babel-plugin-transform-es3-property-literals";

/* 轮播数据 */
const caseData = [
  {
    name: '长青集团',
    fullName: '广东长青（集团）股份有限公司',
    desc: '其环保新能源产业主营的环保热能的项目策划、投资、建设和运营环保装备的研发和制造',
    href: 'http://www.chinachant.com/',
    src: require('./images/banner-01.jpg')
  },
  {
    name: '众合科技',
    fullName: '浙江众合科技股份有限公司',
    desc: '国家重点发展的轨道交通业务和能源环保业务',
    href: 'http://www.swet.net.cn/index.html',
    src: require('./images/banner-02.jpg')
  },
  {
    name: '神雾环保',
    fullName: '神雾环保技术股份有限公司',
    desc: '向煤化工、石油化工客户提供节能环保综合解决方案',
    href: 'ttp://www.swet.net.cn/index.html',
    src: require('./images/banner-03.jpg')
  },
  {
    name: '天翔环境',
    fullName: '成都天翔环境股份有限公司',
    desc: '节能环保及清洁能源设备的研发、生产、销售和服务',
    href: 'http://www.tbhic.cn/',
    src: require('./images/banner-04.jpg')
  },
];
/* 动态新闻数据 */
const newsData = [
  {
    title: '礼瀚团建：毛里求斯——享受自然与冒险',
    time: '2016年9月2日',
    href: 'http://mp.weixin.qq.com/s?__biz=MzI5NTMzMjEwNA==&mid=2247483689&idx=1&sn=544e5aa8f3cb9d10145958537c9d2e76&scene=1&srcid=0923RxbtOpT6Hzz3AJlBULry#rd',
    desc: '毛里求斯被誉为人间天堂，除却妩媚而又纯净的海岛风光，更重要的是因为在这里，你可以忘却所有的烦恼，享受自然，享受冒险，享受生命中因太多烦恼而错过的大好时光。从杭州到毛里求斯，礼瀚团队来这里赴一场与自然和心灵的约会。',
    src: require('./images/2.jpg')
  },
  {
    title: '牵手兴源环境 设立环保产业基金',
    time: '2016年8月27日',
    href: 'http://mp.weixin.qq.com/s?__biz=MzI5NTMzMjEwNA==&mid=2247483680&idx=1&sn=13a520365472bda45e0f9a4ef6c6ffc0&scene=1&srcid=0923uuFJJaXdz6OTGqkUqILE#rd',
    desc: '礼瀚投资的每一位员工致力于用最专业的态度和最规范的操作为投资人和被投资企业出谋划策，用高效的行动力和创造性的思维赢得合作方的尊重与信任。',
    src: require('./images/3.jpg')
  },
  {
    title: '礼瀚概念的呈现与解读',
    time: '2016年8月26日',
    href: 'http://mp.weixin.qq.com/s?__biz=MzI5NTMzMjEwNA==&mid=2247483664&idx=1&sn=791fc3b4988eff3aff5413fca8657652&scene=1&srcid=0923E21ltCilDaPCdyC2A9cw#rd',
    desc: '为了拓展兴源环境（300266）的环保产业链,构建环保产业方向的金融支持平台,杭州礼瀚投资管理有限公司(以下简称“礼瀚投资”)携手杭州壹舟投资管理有限公司(以下简称“壹舟投资”)与兴源环境科技股份有限公司(以下简称“兴源环境”)及兴源控股有限公司(以下简称“兴源控股”)于2016年8月26日共同发起设立环保产业基金。',
    src: ''
  },
  {
    title: '礼瀚投资与神雾环保共同构建环保产业金融支持平台',
    time: '2016年3月28日',
    href: 'http://mp.weixin.qq.com/s?__biz=MzAwMzA3NzY0Mw==&mid=404244897&idx=1&sn=6ef5eb2878871f73430f6d24df468e41&scene=1&srcid=0923rA1ZtImEKIPBHnUbFuRK#rd',
    desc: '牵手礼瀚投资，构建环保产业金融支持平台。为了扩展环保产业链，构建环保产业方向的金融支持平台，神雾环保与礼瀚投资签署战略合作协议。在合作协议框架下，公司将充分发挥研发及产业资源渠道优势，并由礼瀚投资把握环保行业的投资机会，取长补短，依托成立私募股权基金、产业并购基金等方式实现产业与金融有机结合。合作双方首期发起设立产业基金规模约3亿元。我们认为该项合作有利于扩展公司业务规模，增强公司的盈利能力。',
    src: ''
  },
  {
    title: '礼瀚投资入驻杭州玉皇山南基金小镇',
    time: '2016年3月初',
    href: 'http://mp.weixin.qq.com/s?__biz=MzAxNjAwOTQ3NQ==&mid=402072404&idx=1&sn=bd6fe51fff7aca8d86399d0883aaaa04&scene=1&srcid=0923Dp4MVWYr6NCK1mxp11xs#rd',
    desc: '玉皇山南基金小镇管委会党组书记袁维民特别提到，基金小镇始终明确的功能定位是：要为整个实体经济的转型升级、创新创业服务。金融归根结底要回归实业，没有实业支持，资本市场无法实现健康、良性的发展。',
    src: ''
  },
];

function templateImportantNews(value) {
  return (`
      <li class="fl">
        <a class="news-left fl" href="${value.href}">
          <img src="${value.src}" alt="news">
        </a>
        <div class="fl news-right">
          <div>
              <h2><a href="${value.href}" title="${value.title}" target="_blank">${value.title}</a></h2>
              <p> ${value.desc} </p>
              <a href="${value.href}" target="_blank">
                了解更多
                <i class="right-arrow  iconfont icon-jiantou-copy"></i>
              </a>
          </div>
        </div>
      </li>
    `);
}

function templateNormalNews(value) {
  return (`
      <li class="fl">
        <i class="iconfont icon-quanquanb"></i>
        <a href="${value.href}" title="${value.title}" target="_blank">
            ${value.title}
        </a>
        <time class="fr">${value.time}</time>
      </li>
    `);
}


export default function () {
  /* 初始化 */

  /**
   * 动态新闻部分添加内容
   */
  let importantNewsArr = [];
  let normalNewsArr = [];

  newsData.forEach((value, index)=> {
    index < 2 ?
      importantNewsArr.push(templateImportantNews(value))
      :
      normalNewsArr.push(templateNormalNews(value));
  });


  $('.dynamic-news .important-news').html(importantNewsArr.join(''));
  $('.dynamic-news .normal-news').html(normalNewsArr.join(''));
// $('.important-news li:last').addClass('last');


  /* 轮播部分添加图片和文案 */
  let imgArr = [];
  let contentArr = [];
  let len = caseData.length;

  caseData.forEach(value=> {
    imgArr.push(`<li class="fl"><a href="${value.href}"  target="_blank"><img src="${value.src}" alt="${value.name}"></a></li>`);
    contentArr.push(`
    <li>
      <div>
        <h2>${value.name}</h2>
        <h3>${value.fullName}</h3>
        <p>${value.desc}</p>
      </div>
      <a href="${value.href}" target="_blank">
        了解更多
        <i class="right-arrow iconfont icon-jiantou-copy"></i>
      </a>
    </li>
  `);
  });

  fnTab();


  /*
   * 图片轮播
   */
  const $carouse = $('.carouse');
  const $imgsBox = $('.imgs-box');
  const $detail = $('.detail');
  let $detailLis = $('.detail li');
  let carouseWidth = $carouse.width();
  let index = 0;

//初始化图片和内容的容器的高度
  $imgsBox.width(carouseWidth * len);
  $detail.height($detailLis[0].offsetHeight);

//点击右箭头
  $('.next', $carouse).on('click', function (e) {
    index++;
    if (index == len) {
      $('.case .imgs-box').append($('.imgs-box > li:first').detach());
      $('.detail > ul').append($('.detail  li:first').detach());
      $imgsBox.css('left', -carouseWidth * (len - 2) + 'px');
      index--;
    }
    change(index, carouseWidth, $imgsBox, e);
  });

//点击左箭头
  $('.prev', $carouse).on('click', function (e) {
    index--;
    if (index == -1) {
      $('.case .imgs-box').prepend($('.imgs-box > li:last').detach());
      $('.detail > ul').prepend($('.detail  li:last').detach());
      $imgsBox.css('left', -carouseWidth + 'px');
      index++;
    }
    change(index, carouseWidth, $imgsBox, e);
  });

  /*
   * 轮播添加图片和文案
   */
  function fnTab() {
    $('.carouse > ul').html(imgArr.join(''));
    $('.detail > ul').html(contentArr.join(''));
    $('.detail li:first').css('display', 'block');
  }

  /*
   * 图片切换时的动画
   */
  function change(index, carouseWidth, $imgsBox, e) {
    $('.detail li').fadeOut(0)
      .eq(index).fadeIn(500);
    $imgsBox.animate({
      left: -index * carouseWidth + 'px'
    }, 500);
    e.preventDefault();
    e.stopPropagation();
  }

}
