import $ from 'jquery';

const rsubstitute = /\\?\{\{\s*([^{}\s]+)\s*\}\}/mg;

function isString(str){
  return typeof str === 'string';
}

export default function (str, o, reserve) {
  if (!isString(str) && !$.isArray(o) && !$.isPlainObject(o)) {
    return str;
  }
  return str.replace(rsubstitute, function (match, name) {
    if (match.charAt(0) === '\\') {
      return match.slice(1);
    }
    return (o[name] == null) ? reserve ? match : "" : o[name];
  })
}
