import "./team.less";
import $ from "jquery";
import "./team.html";






//团队数据
const teamsData = [
    {
        name: '杨媛',
        job: '总经理',
        desc: '法学专业，12年金融从业经验。熟悉证券、基金、银行、保险金融业务。具有金融公司运营、管理经验，熟悉相关政策和法规。<br/>擅长私募基金项目开发，股权、债券等产品设计，销售渠道开发。具有基金业从业资格。',
        largeImg: require('./images/yangyuan.png'),
        smallImg: require('./images/yangyuan-small.jpg')
    },
    {
        name: '葛健斌',
        job: '副总经理',
        desc: '毕业于南京财经大学，中国注册会计师，具有基金业从业资格。<br/>近10年证券业相关单位从业经验，历任天健会计师事务所高级项目经理，具有多年IPO、并购重组实战经验，主要负责金固股份、恒生电子、利欧股份、浙报传媒等上市公司的年报审计、并购重组及IPO等事项。<br/>2015年加入杭州礼瀚，任公司副总经理，任职期间，公司与众合科技、天翔环境等上市公司形成了全面战略合作。公司环保能源产业事业部主要负责人，管理基金规模超10亿元。',
        largeImg: require('./images/gejianbin.png'),
        smallImg: require('./images/gejianbin-small.jpg')
    },
    {
        name: '刘川',
        job: '环保能源事业部副总',
        desc: '毕业于浙江财经大学，中国注册会计师。<br/>近6年证券业相关单位从业经验，曾任天健会计师事务所项目经理、国信证券投行部项目经理，主要参与过海正药业、升华拜克、兔宝宝等上市公司的年报审计、并购重组及IPO等事项。<br/>2016年加入杭州礼瀚，公司环保能源产业事业部主要成员。',
        largeImg: require('./images/liuchuan.png'),
        smallImg: require('./images/liuchuan-small.jpg')
    },
    // {
    //     name: '吴霄薇',
    //     job: '研究部副总',
    //     desc: '曾任职于安可国际公关公司，具有多年公共关系行业经验，服务于各金融、政府以及非政府机构。曾为中国工商银行、中信证券、瑞士信贷等机构提供企业传播、金融政策研究等服务。<br/>香港浸会大学社会科学学士以及伦敦政治经济学院理学硕士毕业，具有基金业从业资格。',
    //     largeImg: require('./images/wuxiaowei.png'),
    //     smallImg: require('./images/wuxiaowei-small.jpg')
    // },
    {
        name: '罗杭婷',
        job: '产品部总经理',
        desc: '金融学专业毕业，具有基金业从业资格。<br/>丰富的金融工作经验，熟悉产品设计、基金架构搭建、股权投资等主要私募基金模式。曾参与产业基金、并购基金、定增基金、过桥基金以及员工股权激励平台的设计和执行。合作参与的上市公司包括天翔环境、兴源环境、长青集团、易事特、思创医惠等。',
        largeImg: require('./images/luohangting.png'),
        smallImg: require('./images/luohangting-small.jpg')
    },
    {
        name: '吴炜',
        job: '财务总经理',
        desc: '金融学专业，11年财务从业经验，具有会计从业资格证，房地产估价师证。熟悉财务、银行、税务、投融资业务。熟悉公司运营管理及相关法律法规，目前负责财务管理工作。',
        largeImg: require('./images/wuwei.png'),
        smallImg: require('./images/wuwei-small.jpg')
    },
    // {
    //     name: '沈好文',
    //     job: '产品经理',
    //     desc: '浙江工商大学理学学士以及美国圣约瑟夫大学金融硕士。具有证券从业资格、基金从业资格，通过CFA1级考试。熟悉公司经营情况、盈利模式、现金流等分析方法、行业研究方法和权益、债券、公司整体估值、定价方法，有海外财务工作经验和券商工作经验。',
    //     largeImg: require('./images/shenhaowen.png'),
    //     smallImg: require('./images/shenhaowen-small.jpg')
    // },
];

export default function() {

  const $introduceMain = $('.introduce-main');
  const $modalBox = $('.modal-box');
  const $close = $('.close', $modalBox);
  /* 初始化 */
  let lis = teamsData.reduce((arr, value,index)=> {
    arr.push(`
        <li class="partner-pic fl" data-index=${index}>
            <img src="${value.smallImg}" alt="">
            <h2>${value.name} ${value.job}</h2>
        </li>
    `);
    return arr;
  }, []);

  $('.team .partners-leaders').html(lis[0] + lis[1] + lis[2]);
    lis.splice(0,3);
  $('.introduce-main .partners-normal').html(lis.join(''));


  /*
   * 点击箭头,团队介绍部分出现和隐藏
   */
  $('.team .arrow > i').on('click', function () {
    $introduceMain.slideToggle(300);
    $(this).hasClass('slideDown') ? $(this).removeClass('slideDown') : $(this).addClass('slideDown');
  });

  /*
   * 点击合伙人图片,模态框出现
   * 点击模态框X,模态框隐藏
   */
  $('ul.partners').on('click', 'li', function (e) {
      let teamData  =  teamsData[$(this).data('index')];
      $modalBox.fadeIn(300);

      $('.modal-box .modal-content').html(`
            <div class="left-pic fl">
                <img src="${teamData.largeImg}" alt="${teamData.name}"/>
             </div>
             <div class="right-content fl">
                <div>
                  <i class="left-quotes iconfont icon-yinhao"></i>
                  <i class="right-quotes iconfont icon-youyinhao"></i>
                  <h2>${teamData.name}  ${teamData.job}</h2>
                  <p>${teamData.desc}</p>
                </div>
             </div>
        `);
      e.stopPropagation();
      e.preventDefault();
  });

  $close.on('click', ()=> {
      $modalBox.fadeOut(300);
      $('.modal-box .modal-content').html('');
  })

}
