package com.tjk.vo;
/**
 * 所有分页组件的父类，用来封装公共的分页条件
 * @author Administrator
 *
 */
public class PageVo {
	//当前访问的页码，默认是第一页
		private int currentPage=1;
		//每页显示最大行数，是固定值
		private int pageSize=10;
		//总页数,在get方法中自动计算，发送至页面
		private int totalPage;
		//总行数
		private int rows;
		//需要在执行sql前运算出begin和end
		//在执行sql时利用这个运算结果，在get方法计算即可
		private int begin;
		private int end;
		//
		
		public int getRows() {
			return rows;
		}
		public void setRows(int rows) {
			this.rows = rows;
		}
		public int getTotalPage() {
			if (rows%pageSize==0) {
				totalPage=rows/pageSize;
			}else {
				totalPage=rows/pageSize+1;
			}
			return totalPage;
		}
		public void setTotalPage(int totalPage) {
			this.totalPage = totalPage;
		}
		public int getBegin() {
			begin=(currentPage-1)*pageSize;
			return begin;
		}
		public void setBegin(int begin) {
			this.begin = begin;
		}
		public int getEnd() {
			return pageSize;
		}
		public void setEnd(int end) {
			this.end = end;
		}
		public int getCurrentPage() {
			return currentPage;
		}
		public void setCurrentPage(Integer currentPage) {
			if (currentPage != null && currentPage >0) {
				this.currentPage = currentPage;
			}
		}
		public int getPageSize() {
			return pageSize;
		}
		public void setPageSize(int pageSize) {
			this.pageSize = pageSize;
		}
}

