package com.tjk.dao;

import java.util.List;

import com.tjk.annotation.MyBatisRepository;
import com.tjk.vo.ProductRelationVo;
import com.tjk.vo.ProductListVo;
import com.tjk.vo.ProductQueryVo;
import com.tjk.entity.ProductSampleEntity;
import com.tjk.entity.ProductCommission;
import com.tjk.entity.ProductBasic;
import com.tjk.entity.ProductIssue;
import com.tjk.entity.ProductPerformance;
import com.tjk.entity.ProductDescription;
import com.tjk.entity.ProductSubscribe;

@MyBatisRepository
public interface ProductMapper {
	// 查看基金产品
	List<ProductSampleEntity> getSampleEntity(ProductListVo vo);
	//查看单看产品返佣比例
	List<ProductCommission> getProductCommission(Integer productId);
	//查看单只基金净值信息
	List<ProductPerformance> getProductPerformance(ProductQueryVo vo);
	//查看指定日期当天及之后的所有的沪深300指数数据
	List<ProductPerformance> getHSPerformance(com.tjk.entity.PerformanceQuery pq);
	//查看基金附件等其他信息
	List<ProductRelationVo> listProductAttachment(Integer productId);
	//查看单支产品信息，没有权限要求的信息
	List<ProductRelationVo> listProduct(Integer productId);
	//返回单只产品的基本信息
	ProductBasic getProductBasic(Integer productId);
	//返回单只产品的描述信息
	ProductDescription getProductDescription(Integer productId);
	//返回单只产品的发行信息
	ProductIssue getProductIssue(Integer productId);
	//反回单只产品的认购信息
	ProductSubscribe getProductSubscribe(Integer productId);
	//返回产品预约总额
	Integer getTotalAppointment(Integer productId);
	//返回产品已打款总额
	Integer getTotalPayment(Integer productId);
	//返回单个产品最新业绩
	ProductPerformance getProductPerformanceByProductId(Integer productId);
}
