package com.tjk.controller;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.tjk.comm.CommonTool;
import com.tjk.comm.ReadPro;
import com.tjk.comm.Uploader;
import com.tjk.entity.Favorite;
import com.tjk.entity.Meeting;
import com.tjk.entity.News;
import com.tjk.entity.ProductBasic;
import com.tjk.entity.Sms;
import com.tjk.entity.User;
import com.tjk.entity.Address;
import com.tjk.entity.Bankcard;
import com.tjk.entity.UserFeedback;
import com.tjk.entity.UserVerify;
import com.tjk.sms.SmsSender;
import com.tjk.vo.FavoritePageVo;
import com.tjk.vo.ProductRelationVo;
import com.tjk.vo.SmsVo;
import com.tjk.vo.UserVerificationInfoVo;

@Controller
public class UserController extends UserBaseController{
	@Resource 
	ReadPro read;
	/**
	 * 
	 * 
	 * @param mobile
	 * @param pwd
	 * @param verify_code
	 */
	@RequestMapping("/api/user/register.do")
	public void register( HttpServletRequest request, HttpServletResponse response,String uname ,String mobile, String password, String verify_code, Integer role) {
		JsonEntity json = this.getJsonInstance();
		if (this.checkSmsCode(mobile, verify_code)) {
			if( userMapper.checkUserByMobile(mobile) == 0 ){ //手机号码没注册才允许注册
				User user = new User();
				user.setUid(userMapper.getMaxUid() + 1);
				user.setName(uname);
				user.setMobile(mobile);
				user.setVerifyMobile(1);//手机验证码注册过来的，默认为认证手机号码
				user.setPassword(this.createPWD(password));
				if(role==null||role.equals("")){
					user.setRole(2);
				}else{
					user.setRole(role);
				}
				if (userMapper.registerUser(user) == 1) {
					boolean loginStatus = false;
					String pwd = this.createPWD(password);
					if (user.getPassword().equals(pwd)) {
						loginStatus = true;
						this.writeCookie(response, user.getUid());
					}
					if (loginStatus != true) {
						json.setStatus(301);
					}
				}else{
					json.setStatus(400);
				}
			} else {
				json.setStatus(320);
			}
		} else {
			json.setStatus(317);
		}
		json.flush(response);
	}
	
	@RequestMapping("/api/user/send_sms.do")
	public void sendSms( HttpServletRequest request, HttpServletResponse response, String mobile ,Integer smsType){
		JsonEntity json = this.getJsonInstance();
		String ip = CommonTool.getIP(request);
		Integer vcode = CommonTool.getRandom(100000, 999999);
		json.setStatus(400);
		SmsVo vo=new SmsVo(mobile, smsType, ip);
		if (CommonTool.isMobileNO(mobile)) {
			//同一手机号码一天最多发3条，同一IP地址，一天最多发20条
			if (smsMapper.countByMobileOneDay(vo) < 3 && smsMapper.countByIpOneDay(vo) < 20){
		        Sms sms = new Sms();
		        sms.setMobile(mobile);
		        sms.setCode(vcode.toString());
		        sms.setIp(ip);
		        sms.setSmsType(smsType);
		        sms.setContent(read.readProperties("verifyCode1") + vcode.toString() + read.readProperties("verifyCode2"));
		        //发送短信并记录数据库
		        if (smsMapper.addSms(sms) == 1) {
			        if (SmsSender.snedValidcodeSms(mobile, sms.getContent()) == 0) {
			        	json.setStatus(200);
			        }
		        }
			} else {
				json.setStatus(313);
			}
		} else {
			json.setStatus(400);
		}
        json.flush(response);
	}
	//提醒短信
	@RequestMapping("/api/user/send_remind_sms.do")
	public void sendRemindSms( HttpServletRequest request, HttpServletResponse response, String mobile, String content){
		JsonEntity json = this.getJsonInstance();
		String ip = CommonTool.getIP(request);
		Integer vcode = CommonTool.getRandom(100000, 999999);
		if (CommonTool.isMobileNO(mobile)) {
			SmsVo vo=new SmsVo(mobile,3,ip);
			//同一手机号码一天最多发10条，同一IP地址，一天最多发20条
			if (smsMapper.countByMobileOneDay(vo) < 10 && smsMapper.countByIpOneDay(vo) < 20){
		        Sms sms = new Sms();
		        sms.setMobile(mobile);
		        sms.setCode(vcode.toString());
		        sms.setIp(ip);
		        sms.setSmsType(3);//提醒短信
		        sms.setContent(content);
		        //发送短信并记录数据库
		        if (SmsSender.snedValidcodeSms(mobile, sms.getContent()) != 0 || smsMapper.addSms(sms) != 1) {
		        	json.setStatus(400);
		        }
			} else {
				json.setStatus(313);
			}
		} else {
			json.setStatus(400);
		}
        json.flush(response);
	}
	
	@RequestMapping("/api/user/modify_portrait.do")
	public void modifyPortrait(HttpServletRequest request, HttpServletResponse response) {
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if (uid > 0) {//未登陆不允许上传图片
			Uploader uploader = new Uploader(request);
			uploader.uploadBase64("portrait");
			String portrait_uri = uploader.getUrl();
			if (uploader.getState().equals("SUCCESS")) {//图片保存成功后，方处理数据库更新操作
				User user = new User();
				user.setUid(uid);
				user.setPortraitUri(portrait_uri);
				if (userMapper.modifyUserPortrait(user) != 1) {
					json.setStatus(315);
				} else {
					HashMap<String, String> returnMap = new HashMap<String, String>();
					returnMap.put("portrait_uri", portrait_uri);
					json.setData(returnMap);
				}
			}
		} else {
			json.setStatus(311);
		}
		json.flush(response);
	}
	
	@RequestMapping("/api/user/login.do")
	public void loginUser(HttpServletRequest request, HttpServletResponse response, String mobile, String password) {
		JsonEntity json = this.getJsonInstance();
		User user = userMapper.findUserByMobile(mobile);
		boolean loginStatus = false;
		if (user != null && user.getUid() > 0) {
			String pwd = this.createPWD(password);
			if (user.getPassword().equals(pwd)) {
				loginStatus = true;
				this.writeCookie(response, user.getUid());
				Cookie cn = null;
				try {
					cn = new Cookie("uname", java.net.URLEncoder.encode(user.getName(),"UTF-8"));
					cn.setMaxAge(365*24*60*60);
					cn.setPath("/");
					response.addCookie(cn);
				} catch (UnsupportedEncodingException e) {
					e.printStackTrace();
				}
				
			}
		}
		if (loginStatus != true) {
			json.setStatus(301);
		}
		json.flush(response);
	}
	
	@RequestMapping("/api/user/apply_certification.do")
	public void applyCertification(HttpServletRequest request, HttpServletResponse response){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if(uid != 0) {
			Uploader uploader = new Uploader(request);
			uploader.uploadBase64("imgBase64");
			String cardUri = uploader.getUrl();
			if (uploader.getState().equals("SUCCESS")) {//图片保存成功后，方处理数据库更新操作
				User u=userMapper.findUserByUid(uid);
				UserVerify user = new UserVerify();
				user.setUid(uid);
				user.setName(u.getName());
				user.setMobile(u.getMobile());
				//限制用户一天内的认证次数
				Integer count=userMapper.countVerifyInfo(uid);
				if(count==null||count<5){
					u.setCardUri(cardUri);
					user.setCardUri(cardUri);
					//将用户角色改为理财师，未认证
					u.setRole(1);
					u.setIsVerify(0);
					if (userMapper.verifyUser(user) != 1||userMapper.modifyUserCard(u)!=1) {
						json.setStatus(400);
					}
				}else{
					json.setStatus(323);
				}
			} else {
				json.setStatus(315);
			}
		} else {
			json.setStatus(311);
		}
		json.flush(response);
	}
	//忘记密码
	@RequestMapping("/api/user/reset_pwd.do")
	public void resetPWD(HttpServletRequest request, HttpServletResponse response, String mobile, String verify_code, String newpwd) {
		JsonEntity json = this.getJsonInstance();
		Integer rs = 400;
		User user = userMapper.findUserByMobile(mobile);
		if (user != null) {
			//判断短信验证码是否正确
			if (!this.checkSmsCode(user.getMobile(), verify_code)) {
				rs = 317;
			} else {
				user.setPassword(this.createPWD(newpwd));
				if (userMapper.changePassword(user) == 1) {
					rs = 200;
				}
			}
		} else {
			rs = 312;
		}
		json.setStatus(rs);
		json.flush(response);
	}
	//获取用户数据，登陆后才可以调用否则会不回错误
	@RequestMapping("/api/user/get_user_info.do")
	public void getUserInfo(HttpServletRequest request, HttpServletResponse response) {
		JsonEntity json = this.getJsonInstance();
		HashMap<String, User> hm = new HashMap<String, User>();
		Integer uid = this.validUser(request);
		Integer rs = 311;
		if(uid != 0) {
			User user = userMapper.findUserByUid(uid);
			if(user.getCompanyId()!=null){
				String companyName = userMapper.getCompanyNameById(user.getCompanyId());
				user.setCompanyName(companyName);
			}
			if (user != null ) {				
				hm.put("userinfo", user);
				json.setData(hm);
				json.setStatus(200);
			}
		}else{
			hm.put("userinfo", null);
			json.setStatus(rs);
		}
		json.flush(response);
	}
	//获取用户认证信息
	@RequestMapping("/api/user/get_user_verify.do")
	public void getUserVerify(HttpServletRequest request, HttpServletResponse response,Integer uid) {
		JsonEntity json = this.getJsonInstance();
		HashMap<String, User> hm = new HashMap<String, User>();
		if(uid != null&&uid!=0) {
			User user = userMapper.findUserByUid(uid);
			if(user!=null){
				if(user.getCompanyId()!=null){
					String companyName = userMapper.getCompanyNameById(user.getCompanyId());
					user.setCompanyName(companyName);
				}
				if(user.getIsVerify() == 1){
					hm.put("user", user);
					json.setData(hm);
				}else if (user.getIsVerify()!=1 ) {				
					json.setStatus(321);
				}
			}else{
				json.setStatus(321);
			}
		}else{
			json.setStatus(321);
		}
		json.flush(response);
	}
	//修改用户信息
	@RequestMapping("/api/user/update_user_info.do")
	public void updateInfo(HttpServletRequest request, HttpServletResponse response, User user){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if(uid>0){
			User u=userMapper.findUserByUid(uid);
			u.setName(user.getName());
			u.setEmail(user.getEmail());
			if(userMapper.updateInfo(u)!=1){
				json.setStatus(400);
			}
		}else{
			json.setStatus(311);
		}
		json.flush(response);
	}
	//修改密码
	@RequestMapping("/api/user/change_pwd.do")
	public void changePWD(HttpServletRequest request, HttpServletResponse response, String oldpwd, String newpwd) {
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		Integer rs = 400;
		if(uid != 0) {
			User user = userMapper.findUserByUid(uid);
			if (user != null && user.getPassword().equals(this.createPWD(oldpwd))) {//先判断老密码是否有效
				user.setPassword(this.createPWD(newpwd));
				if(userMapper.changePassword(user) == 1) {
					rs = 200;
				}
			}
		}
		json.setStatus(rs);
		json.flush(response);
	}
	
	@RequestMapping("/api/user/get_address.do")
	public void getAddress(HttpServletRequest request, HttpServletResponse response) {
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if (uid > 0) {
			List<Address> addresses = userMapper.findAddressByUid(uid);
			if (addresses!= null && addresses.size() > 0) {
				json.setDatas(addresses);
			} else {
				json.setStatus(400);
			}
		} else {
			json.setStatus(311);
		}
		json.flush(response);
		//this.responseJosn(response);
	}
	
	@RequestMapping("/api/user/add_address.do")
	public void addAddress(HttpServletRequest request, HttpServletResponse response, String contact, String phone, String address) {
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if (uid > 0) {
			List<Address> al = userMapper.findAddressByUid(uid);
			if (al.size() >= 20) {//一个用户默认只能开通20个地址，多了后要求用户删除
				json.setStatus(318);
			} else {
				Address addr = new Address();
				addr.setUid(uid);
				addr.setAddress(address);
				addr.setPhone(phone);
				addr.setContact(contact);
				addr.setIsDefault(1);
				Integer max=userMapper.findMaxAddressId();
				if(max==null){
					max=Integer.parseInt(readPro.readProperties("address_id_min"));
					addr.setAddressId(max);
				}else{
					addr.setAddressId(max+1);
				}
				//设置其它地址的isDefault=0
				userMapper.updateDefaultAddress(uid);
				if (userMapper.addAddress(addr) != 1) {
					json.setStatus(400);
				}
			}
		} else {
			json.setStatus(311);
		}
		json.flush(response);
		//this.responseJosn(response);
	}
	
	//获取地址信息
	@RequestMapping("/api/user/get_address_by_address_id.do")
	public void getAddressDetail(HttpServletRequest request, HttpServletResponse response,Integer addressId){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if(uid>0){
			Address address=userMapper.findAddressByAddressId(addressId);
			if(address!=null){
				HashMap<String,Address > map=new HashMap<String, Address>();
				map.put("address", address);
				json.setData(map);
			}else{
				json.setStatus(309);
			}
		}else{
			json.setStatus(311);
		}
		json.flush(response);
	}
	
	//修改地址信息
	@RequestMapping("/api/user/update_address.do")
	public void updateAddress(HttpServletRequest request, HttpServletResponse response,Address address){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if(uid>0){
			Address addr=userMapper.findAddressByAddressId(address.getAddressId());
			if(addr!=null){
				if(userMapper.updateAddress(address)!=1){
					json.setStatus(400);
				}
			}else{
				json.setStatus(309);
			}
		}else {
			json.setStatus(311);
		}
		json.flush(response);
	}
	
	@RequestMapping("/api/user/del_address.do")
	public void delAddress(HttpServletRequest request, HttpServletResponse response, Integer id) {
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if (uid > 0) {
			Address address = new Address();
			address.setAddressId(id);
			address.setUid(uid);
			if (userMapper.delAddress(address) != 1) {
				json.setStatus(400);
			}
		} else {
			json.setStatus(311);
		}
		json.flush(response);
	}
	
	@RequestMapping("/api/user/get_bankcard.do")
	public void getBankcard(HttpServletRequest request, HttpServletResponse response) {
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if (uid > 0) {
			List<Bankcard> cards = userMapper.findBankcardByUid(uid);
			if (cards!= null && cards.size() > 0) {
				json.setDatas(cards);
			} else {
				json.setStatus(400);
			}
		} else {
			json.setStatus(311);
		}
		json.flush(response);
		//this.responseJosn(response);
	}
	
	@RequestMapping("/api/user/add_bankcard.do")
	public void addBankcard(HttpServletRequest request, HttpServletResponse response, String openbank, String openname, String cardno) {
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if (uid > 0) {
			List<Bankcard> al = userMapper.findBankcardByUid(uid);
			if (al.size() >= 10) {//最多只能关联10张银行卡
				json.setStatus(319);
			} else {
				Bankcard card = new Bankcard();
				card.setOpenBank(openbank);
				card.setOpenName(openname);
				card.setOpenCardno(cardno);
				card.setUid(uid);
				card.setIsDefault(1);
				Integer max=userMapper.findMaxCardId();
				if(max==null){
					max=Integer.parseInt(readPro.readProperties("bank_card_id_min"));
					card.setCardId(max);
				}else{
					card.setCardId(max+1);
				}
				//设置其它银行卡的isDefault=0
				userMapper.updateDefaultBankCard(uid);
				if (userMapper.addBankcard(card) != 1) {
					json.setStatus(400);
				}
			}
		} else {
			json.setStatus(311);
		}
		json.flush(response);
		//this.responseJosn(response);
	}
	//获取银行卡信息
	@RequestMapping("/api/user/get_bankcard_by_card_id.do")
	public void getBankcardByCardId(HttpServletRequest request, HttpServletResponse response, Integer cardId){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if (uid > 0) {
			Bankcard bankcard = userMapper.findBankcardByCardId(cardId);
			if(bankcard!=null){
				HashMap<String, Bankcard> map=new HashMap<String, Bankcard>();
				map.put("bankcard", bankcard);
				json.setData(map);
			}else{
				json.setStatus(308);
			}			
		} else {
			json.setStatus(311);
		}
		json.flush(response);
	}
	//修改银行卡
	@RequestMapping("/api/user/update_bankcard.do")
	public void updateBankCard(HttpServletRequest request, HttpServletResponse response,Bankcard bankcard){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if (uid > 0) {
			Bankcard card=userMapper.findBankcardByCardId(bankcard.getCardId());
			if(card!=null){
				if(userMapper.updateBankCard(bankcard)!=1){
					json.setStatus(400);
				}
			}else{
				json.setStatus(308);
			}
		} else {
			json.setStatus(311);
		}
		json.flush(response);
	}
	
	@RequestMapping("/api/user/del_bankcard.do")
	public void delBankcard(HttpServletRequest request, HttpServletResponse response, Integer id) {
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if (uid > 0) {
			Bankcard bankcard = new Bankcard();
			bankcard.setCardId(id);
			bankcard.setUid(uid);
			if (userMapper.delBankcard(bankcard) != 1) {
				json.setStatus(400);
			}
		} else {
			json.setStatus(311);
		}
		json.flush(response);
	}
	
	@RequestMapping("/api/user/supply_info.do")
	public void supplyInformation(HttpServletRequest request, HttpServletResponse response, User user) {
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if (uid > 0) {
			if (userMapper.supplyInformation(user) != 1) {
				json.setStatus(400);
			}
		} else {
			json.setStatus(311);
		}
		json.flush(response);
	}

	//将产品附件发送至邮箱
	@RequestMapping("api/user/send_attachment.do")
	public void sendAttachment(HttpServletRequest request, HttpServletResponse response,String receiveUser,Integer productId,String productName) throws IOException{
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if(uid>0){
			Map<String,String> map=new HashMap<String,String>();
			//查询产品相关附件
			List<ProductRelationVo> list=productMapper.listProductAttachment(productId);
			if(list!=null&&list.size()>0){
				List<File> listAtta=new ArrayList<File>();
				//将附件加入附件集合
				for (ProductRelationVo productRelationVo : list) {
				    String name=productRelationVo.getUri();
				    String temp=request.getServletContext().getRealPath("");
				    temp=temp.substring(0, temp.lastIndexOf(File.separator)+1);
				    name=temp+name;
					File atta=new File(name);
					name=atta.getAbsolutePath();
					String title=productRelationVo.getTitle();
					String tem=name.substring(name.lastIndexOf(File.separator)+1, name.lastIndexOf("."));
					name=name.replaceAll(tem, title);
					//将附近给为相关名字
	                atta.renameTo(new File(name));		
	                atta=new File(name);
					listAtta.add(atta);
					map.put(tem, name);
				}
				String content="您好：<br>附件是\"金客\"为您提供的金融产品详细资料，请查收。<br><br>金客--指尖财富管理专家";
				//发送邮件
				if(!tool.SendAtta(productName+" 详细资料", content, receiveUser, listAtta).equals("success")){
					json.setStatus(322);
				}
				//将附近名字改回原来的的名字
				for(Map.Entry<String, String> entry:map.entrySet()){
	            	String name=entry.getValue();
	            	File atta=new File(name);
	            	String tem=entry.getKey();
	            	String title=name.substring(name.lastIndexOf(File.separator)+1, name.lastIndexOf("."));
	            	name=name.replaceAll(title, tem);
					atta.renameTo(new File(name));
	            }
			}else{
				json.setStatus(326);
			}
		}else{
			json.setStatus(311);
		}
		json.flush(response);
	}
	//修改头像
	@RequestMapping("/api/user/modify_head.do")
	public void modifyHead(HttpServletRequest request, HttpServletResponse response){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if(uid != 0) {
			Uploader uploader = new Uploader(request);
			uploader.uploadBase64("imgBase64");
			String headUri = uploader.getUrl();
			if (uploader.getState().equals("SUCCESS")) {//图片保存成功后，方处理数据库更新操作
				User u=userMapper.findUserByUid(uid);
				u.setPortraitUri(headUri);
				if (userMapper.modifyUserPortrait(u)!=1) {
					json.setStatus(400);
				}
			} else {
				json.setStatus(315);
			}
		} else {
			json.setStatus(311);
		}
		json.flush(response);
	}
	//提交反馈信息
	@RequestMapping("/api/user/add_feedback.do")
	public void addFeedback(HttpServletRequest request, HttpServletResponse response,UserFeedback feedback){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if(uid!=0){
			feedback.setUid(uid);
		}
		if(userMapper.addFeedback(feedback)!=1){
			json.setStatus(400);
		}else{
			json.setStatus(200);
		}
		json.flush(response);
	}
	//将银行卡设为默认银行卡
	@RequestMapping("/api/user/default_bankcard.do")
	public void defaultBankCard(HttpServletRequest request, HttpServletResponse response,Integer bankCardId){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if(uid>0){
			Bankcard bankcard=new Bankcard();
			bankcard.setUid(uid);
			bankcard.setCardId(bankCardId);
			if(userMapper.updateDefaultBankCard(uid)<=0||userMapper.defaultBankCard(bankcard)!=1){
				json.setStatus(400);
			}
		}else{
			json.setStatus(311);
		}
		json.flush(response);
	}
	//将邮寄地址设为默认地址
	@RequestMapping("/api/user/default_address.do")
	public void defaultAddress(HttpServletRequest request, HttpServletResponse response,Integer addressId){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if(uid>0){
			Address address=new Address();
			address.setUid(uid);
			address.setAddressId(addressId);;
			if(userMapper.updateDefaultAddress(uid)<=0||userMapper.defaultAddress(address)!=1){
				json.setStatus(400);
			}
		}else{
			json.setStatus(311);
		}
		json.flush(response);
	}
	//获取用户验证信息
	@SuppressWarnings("unused")
	@RequestMapping("api/user/get_verification_info")
	public void getUserVerificationInfo(HttpServletRequest request, HttpServletResponse response,Integer relationId,Integer favoriteType) {
		JsonEntity json = this.getJsonInstance();
		HashMap<String, UserVerificationInfoVo> hm = new HashMap<String, UserVerificationInfoVo>();
		Integer uid = this.validUser(request);
		Integer rs = 311;
		if(uid != 0) {
			Favorite favorite=new Favorite();
			favorite.setUid(uid);
			favorite.setFavoriteType(favoriteType);
			favorite.setRelationId(relationId);
			User user = userMapper.findUserByUid(uid);
			UserVerificationInfoVo u=new UserVerificationInfoVo();
			u.setIsVerify(user.getIsVerify());
			u.setUid(user.getUid());
			if (u != null ) {				
				hm.put("userinfo", u);
			}
			UserVerificationInfoVo userV = userMapper.findUserVerificationInfo(favorite);
			if (user != null ) {				
				hm.put("userVinfo", userV);
				json.setData(hm);
			}else{
				hm.put("userVinfo", null);
				json.setData(hm);
			}
			json.setStatus(200);
		}else{
			json.setStatus(rs);
		}
		json.flush(response);
	}
	//用户收藏
	@RequestMapping("/api/user/collect.do")
	public void collectProduct(HttpServletRequest request, HttpServletResponse response,Integer favoriteType,Integer relationId,String orginUri,String thumbnail){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if(uid>0){
			Favorite favorite=new Favorite();
			//收藏新闻
			if(favoriteType==1){
				News news = newsMapper.findNewsByNewsId(relationId);
				favorite.setTitle(news.getTitle());
				favorite.setThumbnail(thumbnail);
				favorite.setDescription(news.getSummary());
			}
			//收藏产品
			if(favoriteType==2){
				ProductBasic pBasic=productMapper.getProductBasic(relationId);
				favorite.setTitle(pBasic.getProductName());
				favorite.setThumbnail(thumbnail);
				favorite.setDescription(pBasic.getBrightPoint());
			}
			//收藏会议
			if(favoriteType==3){
				Meeting meeting = meetingMapper.getMeetingInfo(relationId);
				favorite.setTitle(meeting.getTitle());
				favorite.setThumbnail(thumbnail);
				favorite.setDescription("<p>"+meeting.getAddress()+"</p><p>"+meeting.getPubTime()+"</p>");
			}
			
			favorite.setOrginUri(orginUri);
			favorite.setUid(uid);
			favorite.setFavoriteType(favoriteType);
			favorite.setRelationId(relationId);
			if(favoriteMapper.addCollect(favorite)!=1){
				json.setStatus(400);
			}
		}else{
			json.setStatus(311);
		}
		json.flush(response);
	}
	//取消收藏
	@RequestMapping("/api/user/cancel_collect.do")
	public void cancleCollectProduct(HttpServletRequest request, HttpServletResponse response,Integer favoriteType,Integer relationId){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if(uid>0){
			Favorite favorite=new Favorite();
			favorite.setUid(uid);
			favorite.setFavoriteType(favoriteType);
			favorite.setRelationId(relationId);
			if(favoriteMapper.cancelCollect(favorite)!=1){
				json.setStatus(400);
			}
		}else{
			json.setStatus(311);
		}
		json.flush(response);
	}
	//查看我的收藏
	@RequestMapping("/api/user/get_collect.do")
	public void getMyCollect(HttpServletRequest request, HttpServletResponse response,Integer favoriteType,Integer pageIndex,boolean flag){
		FavoritePageVo pageVo=new FavoritePageVo();
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		if(uid>0){
			if (pageIndex == null || pageIndex <=0 ) {
				pageIndex = 1;
			}
			pageVo.setCurrentPage(pageIndex);
			pageVo.setUid(uid);
			pageVo.setFavoriteType(favoriteType);
			Integer count=favoriteMapper.findRows(pageVo);
			pageVo.setTotalPage(count);
			//用于判断是否需要分页
			pageVo.setFlag(flag);
			List<Favorite> list=favoriteMapper.getCollect(pageVo);
			if(list!=null){
				json.setDatas(list);
			}
		}else{
			json.setStatus(311);
		}
		json.flush(response);
	}
	//
}
