package com.tjk.controller;

import java.util.Date;
import java.util.List;
import java.util.HashMap;

import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.tjk.comm.CommonTool;
import com.tjk.comm.MD5;
import com.tjk.comm.ReadPro;
import com.tjk.dao.FavoriteMapper;
import com.tjk.dao.MeetingMapper;
import com.tjk.dao.NewsMapper;
import com.tjk.dao.ProductMapper;
import com.tjk.dao.SmsMapper;
import com.tjk.dao.UserMapper;
import com.tjk.dao.TablefieldMapper;
import com.tjk.entity.Sms;
import com.tjk.entity.Tablefield;
import com.tjk.entity.User;

public class UserBaseController extends JsonBaseController{
	@Resource
    CommonTool tool;
	@Resource
    ReadPro readPro;
	@Resource
	UserMapper userMapper;
	@Resource
	SmsMapper smsMapper;
	@Resource
	TablefieldMapper tablefieldMapper;
	@Resource
	ProductMapper productMapper;
	@Resource
	FavoriteMapper favoriteMapper;
	@Resource
	NewsMapper newsMapper;
	@Resource
	MeetingMapper meetingMapper;
	
	private HashMap<Integer, String> tablefield;
	private HashMap<Integer, String> tablefield2;

	public String getCookie(HttpServletRequest request, String key) {

		Cookie[] cookies = request.getCookies();
		if(cookies==null){
			return "";
		}
		for (Cookie c : cookies) {
			if (c.getName().trim().equals(key.trim())) {
				return c.getValue();
			}
		}
		return "";
	}

	public boolean checkCookie(String _id, String _ts, String extra, String token) {
		String checkToken = MD5.GetMD5Code(_id.toString() + "," + _ts.toString() + "," + extra);
		if (checkToken.equals(token)) {
			return true;
		} else {
			return false;
		}
	}

	public boolean writeCookie(HttpServletResponse response, Integer _uid) {
		Long _ts = new Date().getTime();;
		String extra = readPro.readProperties("password");
		String token = MD5.GetMD5Code(_uid.toString() + "," + _ts.toString() + "," + extra);

		Cookie c = new Cookie("token", token);
		c.setPath("/");
		c.setMaxAge(365*24*60*60);
		response.addCookie(c);
		Cookie ts = new Cookie("_ts", _ts.toString());
		ts.setPath("/");
		ts.setMaxAge(365*24*60*60);
		response.addCookie(ts);
		Cookie id = new Cookie("_id", _uid.toString());
		id.setPath("/");
		id.setMaxAge(365*24*60*60);
		response.addCookie(id);
		return true;
	}
	
	//生成加密后的密码
	public String createPWD(String password) {
		String extra = readPro.readProperties("password");
		String newpwd = MD5.GetMD5Code(extra + "," + password);
		return newpwd;
	}
	//检测登录信息是否有效，成功返回:uid
	public Integer validUser(HttpServletRequest request) {
		
		String extra = readPro.readProperties("password");
		String _id = this.getCookie(request, "_id");
		String _ts = this.getCookie(request, "_ts");
		String token = this.getCookie(request, "token");
		if ( this.checkCookie(_id, _ts, extra, token)) {
			return Integer.parseInt(_id);
		}
		return 0;
	}
	//验证身份是否认证
	public boolean validVerify(Integer uid, Integer userType) {
		User user = userMapper.findUserByUid(uid);
		if (user.getRole() == userType && user.getIsVerify() == 1) {
			return true;
		}
		return false;
	}
	//判断短信验证码是否正确
	public boolean checkSmsCode(String mobile, String verify_code) {
		List<Sms> sms = smsMapper.findLastThirtyMinute(mobile);
		boolean check_code = false;
		for (Sms item : sms) { //判断验证码是不是正确的
			if (verify_code.equals(item.getCode())) {
				check_code = true;
				break;
			}
		}
		return check_code;
	}
	
	//快速通过分类表取得对应的字段数据，该方法只分执行一次数据库初始化动作。简称
	public String getTablefield(Integer key) {
		if (this.tablefield == null) {
			this.tablefield= new HashMap<Integer, String>();
			List<Tablefield> _list = tablefieldMapper.getTablefield();
			for (Tablefield _f: _list) {
				this.tablefield.put(_f.getKey(), _f.getValue());
			}
		}
		if (this.tablefield.containsKey(key)) {
			return tablefield.get(key);
		} else {
			return "N/A";
		}
	}
	//全称
	public String getTablefield2(Integer key) {
		if (this.tablefield2 == null) {
			this.tablefield2= new HashMap<Integer, String>();
			List<Tablefield> _list = tablefieldMapper.getTablefield2();
			for (Tablefield _f: _list) {
				this.tablefield2.put(_f.getKey(), _f.getValue());
			}
		}
		if (this.tablefield2.containsKey(key)) {
			return tablefield2.get(key);
		} else {
			return "N/A";
		}
	}
	
	
}
