package com.tjk.controller;

import java.util.HashMap;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.tjk.entity.News;
import com.tjk.vo.NewsPageVo;
import com.tjk.dao.NewsMapper;

@Controller
public class NewsController extends UserBaseController{
	@Resource
	NewsMapper newsMapper;
	
	@RequestMapping("/api/news/list.do")
	public void findNews(HttpServletRequest request, HttpServletResponse response, Integer newsType, Integer pageIndex,Integer rmd){
		JsonEntity json = this.getJsonInstance();
		if (newsType == null || newsType <=0 ) {
			newsType = 1096;
		}
		if (pageIndex == null || pageIndex <=0 ) {
			pageIndex = 1;
		}
		NewsPageVo pageVo = new NewsPageVo();
		pageVo.setNewsType(newsType);
		pageVo.setCurrentPage(pageIndex);
		pageVo.setRmd(rmd);
		List<News> news=newsMapper.findNewsByPage(pageVo);
		for (News n: news) {
			String s = n.getSummary();
			if (s != null && s.length() > 35) {
				n.setSummary(s.substring(0, 35));
			}
		}
		json.setDatas(news);
		json.flush(response);	
	}
	
	@RequestMapping("/api/news/detail.do")
	public void getNewsInfo(HttpServletRequest request, HttpServletResponse response,Integer newsId){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		News news=newsMapper.findNewsByNewsId(newsId);
		if(uid!=0){
			news.setFid(news.getFid());
		}else{
			news.setFid(0);
		}
		if(news.getViewCount()==null){
			news.setViewCount(0);
		}
		news.setViewCount(news.getViewCount()+1);
		newsMapper.plusViewCount(news);
		HashMap<String, Object> map= new HashMap<String,Object>();
		map.put("news", news);
		json.setData(map);
		json.flush(response);	
		
	}
}
  