package com.tjk.controller;

import java.util.HashMap;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.tjk.dao.MeetingMapper;
import com.tjk.entity.Meeting;
import com.tjk.entity.MeetingRegist;
import com.tjk.vo.PageVo;

@Controller
public class MeetingController extends UserBaseController{
	@Resource
	private MeetingMapper meetingMapper;
	
	/**
	 * 添加会议预约信息
	 */
	@RequestMapping("/api/meeting/add_appointment.do")
	public void addMeetingAppointment(HttpServletRequest request, HttpServletResponse response,MeetingRegist regist){
		JsonEntity json = this.getJsonInstance();
		if(meetingMapper.findCountMeetingByMobile(regist.getMobile())==0){
			regist.setStatus(1);
			if(meetingMapper.addMeetingAppointment(regist)!=1){
				json.setStatus(400);
			}
		}else{
			json.setStatus(325);
		}
		json.flush(response);
	}
	
	/**
	 * 查询所有会议
	 */
	@RequestMapping("/api/meeting/list.do")
	public void listAllMeeting(HttpServletRequest request, HttpServletResponse response,Integer pageIndex){
		JsonEntity json = this.getJsonInstance();
		if (pageIndex == null || pageIndex <=0 ) {
			pageIndex = 1;
		}
		int count=meetingMapper.countMeeting();
		PageVo pageVo=new PageVo();
		pageVo.setCurrentPage(pageIndex);
		pageVo.setTotalPage(count);
		List<Meeting> list=meetingMapper.listAllMeetingByPage(pageVo);
		json.setDatas(list);
		json.flush(response);
	}
	/**
	 * 查看会议详细信息
	 */
	@RequestMapping("/api/meeting/find_detail.do")
	public void findMeetingDetail(HttpServletRequest request, HttpServletResponse response,Integer meetingId){
		JsonEntity json = this.getJsonInstance();
		Integer uid = this.validUser(request);
		Meeting meeting=meetingMapper.getMeetingInfo(meetingId);
		if(uid!=0){
			meeting.setFid(meeting.getFid());
		}else{
			meeting.setFid(0);
		}
		if(meeting!=null){
			HashMap<String , Meeting> map=new HashMap<String, Meeting>();
			map.put("meeting", meeting);
			json.setData(map);
		}else{
			json.setStatus(400);
		}
		json.flush(response);
	}
}
