package com.tjk.comm;

import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;  
import java.util.regex.Pattern; 






import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Component;

import com.tjk.email.SendMailWithAtta;

@Component
public class CommonTool {
	
	//邮件发送类
	private static SendMailWithAtta mailSend=new SendMailWithAtta();
	
	//生成指定范围内的随机数
	public static int getRandom(int min, int max) {
        Random random = new Random();
        int vcode = random.nextInt(max) % (max-min+1) + min;
        return vcode;
	}
	//获取IP
	public static String getIP(HttpServletRequest request) {
		String ip = request.getHeader("x-forwarded-for");  
	    if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {  
	        ip = request.getHeader("Proxy-Client-IP");  
	    }  
	    if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {  
	        ip = request.getHeader("WL-Proxy-Client-IP");  
	    }  
	    if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {  
	        ip = request.getHeader("HTTP_CLIENT_IP");  
	    }  
	    if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {  
	        ip = request.getHeader("HTTP_X_FORWARDED_FOR");  
	    }  
	    if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {  
	        ip = request.getRemoteAddr();  
	    }  
	    return ip;  
	}
	
	//判断是否是手机号码增加17、14号段
	public static boolean isMobileNO(String mobiles){
		Pattern p = Pattern.compile("^((13[0-9])|(17[0-9])|(14[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$");
		Matcher m = p.matcher(mobiles);  
		return m.matches();  
	}
	
	//邮件发送--发送附件,合同
	public String SendAtta(String subject,String sendHtml,String receiveUser,List<File> list){
		if(mailSend.sendHtmlEmail(subject,sendHtml , receiveUser, list)==1){
			return "success";
		}
		return "failure";
	}
	
}
