package com.tjk.dao;

import java.util.List;

import com.tjk.annotation.MyBatisRepository;
import com.tjk.entity.Favorite;
import com.tjk.entity.User;
import com.tjk.entity.Address;
import com.tjk.entity.Bankcard;
import com.tjk.entity.UserFeedback;
import com.tjk.entity.UserVerify;
import com.tjk.vo.UserVerificationInfoVo;

@MyBatisRepository
public interface UserMapper {
	Integer findRows();
	//获取最大的uid
	Integer getMaxUid();
	//通过手机号码查找用户
	User findUserByMobile(String mobile);
	//通过uid查找用户
	User findUserByUid(Integer uid);
	//判断手机号码是否已经注册
	Integer checkUserByMobile(String mobile);
	//注册
	Integer registerUser(User user);
	//完善个人信息
	Integer supplyInformation(User user);
	//更改名片，暂时不提供更改名片功能
	Integer modifyUserCard(User user);
	//更改头像
	Integer modifyUserPortrait(User user);
	//提交用户认证信息
	Integer verifyUser(UserVerify userVerify);
	//修改密码
	Integer changePassword(User user);
	//获取地址列表
	List<Address> findAddressByUid(Integer uid);
	//增加地址
	Integer addAddress(Address address);
	//删除地址
	Integer delAddress(Address address);
	//增加银行卡
	Integer addBankcard(Bankcard bankcard);
	//删除银行卡
	Integer delBankcard(Bankcard bankcard);
	//获取用户的银行卡
	List<Bankcard> findBankcardByUid(Integer uid);
	//获取最大的address_id
	Integer findMaxAddressId();
	//获取地址详情
	Address findAddressByAddressId(Integer addressId);
	//修改地址
	Integer updateAddress(Address address);
	//修改默认地址
	Integer updateDefaultAddress(Integer uid);
	//获取最大的card_id
	Integer findMaxCardId();
	//修改默认银行卡
	Integer updateDefaultBankCard(Integer uid);
	//查看银行卡
	Bankcard findBankcardByCardId(Integer cardId);
    //修改银行卡
	Integer updateBankCard(Bankcard bankcard);
	//用户提交反馈信息
	Integer addFeedback(UserFeedback feedback);

	//获取认证理财师的所属公司
	String getCompanyNameById(Integer companyId);
	
	//修改用户信息
	Integer updateInfo(User user);
	//查询用户一天内的认证次数
	Integer countVerifyInfo(Integer uid);
	
	//将银行卡设为默认银行卡
	Integer defaultBankCard(Bankcard bankcard);
	//将邮寄地址设为默认地址
    Integer defaultAddress(Address address);
    
    //查询用户验证信息
    UserVerificationInfoVo findUserVerificationInfo(Favorite favorite);
}
