package com.tjk.dao;

import java.util.List;

import com.tjk.annotation.MyBatisRepository;
import com.tjk.entity.Sms;
import com.tjk.vo.SmsVo;

@MyBatisRepository
public interface SmsMapper {
	List<Sms> findAll();

	Integer addSms(Sms sms);

	List<Sms> findByStatus(int status);
	
	List<Sms> findAllByMobile(String mobile);

	List<Sms> findLastByMobile(String mobile);
	

	List<Sms> findAllByUid(int uid);

	List<Sms> findLastByUid(int uid);
	
	int updateById(Sms sms);
	
	Sms findById(int id);
	
	void deleteById(int id);
	
	int findRows();
	
	//24小时内同一IP发送的短信量
	int countByIpOneDay(SmsVo vo);
	//24小时内，同一手机号码发送的短信量
	int countByMobileOneDay(SmsVo vo);
	//获取用户30分钟内发送的短信列表
	List<Sms> findLastThirtyMinute(String mobile);
}
