package com.tjk.dao;

import java.util.List;

import com.tjk.annotation.MyBatisRepository;
import com.tjk.vo.OrderListVo;
import com.tjk.entity.Attachment;
import com.tjk.entity.Order;
import com.tjk.entity.OrderStatistics;
import com.tjk.entity.OrderStatus;
import com.tjk.entity.UserOrderInvestor;

@MyBatisRepository
public interface OrderMapper {
	//查找出user_order表中最大的id，用来给order_id赋值
	int findMaxId();
	
	int addUserOrder(Order order);
	int addUserOrderStatus(OrderStatus orderStatus);
	
	int modifyUserOrder(Order order);
	
	List<Order> getMyCustomOrder(OrderListVo orderListVo);
	List<Order> getMyOrder(OrderListVo orderListVo);
	Order getOrderDetail(Integer orderId);
	
	OrderStatistics getOrderStatistics(int productId);
	List<OrderStatistics> getOrderStatisticsList();
	List<OrderStatus> getOrderStatus(int orderId);
	//添加邮寄地址
	Integer addOrderAddress(Order order);
	//添加打款银行卡
	Integer addOrderBank(Order order);
	List<Order> getMoney(OrderListVo vo);
	
	//查找凭证
	Attachment findAttachment(Attachment atta);
	//添加用户凭证
	Integer addCertificate(Attachment atta);
	//修改用户凭证
	Integer updateCertificate(Attachment atta);
	
	//查找投资人凭证
	List<Attachment> findAllAttachment(Integer orderId);
	//查找投资人订单
	UserOrderInvestor findInvestor(Integer orderId);
	//添加投资人订单
	Integer addInvesetor(UserOrderInvestor userOrderInvestor);
	//修改投资人订单
	Integer updateInvestor(UserOrderInvestor userOrderInvestor);
}
