package com.tjk.controller;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.HashMap;

import javax.servlet.http.HttpServletResponse;






import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class JsonBaseController {
	/**
	 * 服务器返回状态表
	 */
	public final static HashMap<Integer, String> returnMap = new HashMap<Integer, String>() {
	private static final long serialVersionUID = 81495029526356L;

	{  
	    put(200, "成功");
	    put(301, "用户名或者密码错误");
	    put(302, "尚未认证实理财师身份");
	    put(303	,"输入的密码过于简单");
	    put(304	, "输入的密码不正确");
	    put(305	, "邮箱地址格式不正确");
	    put(306	, "手机号码不正确");
	    put(307, "该产品不存在");
	    put(308	, "该银行卡不存在");
	    put(309	, "该地址不存在");
	    put(310	, "该订单不存在");
	    put(311	, "尚未登陆");
	    put(312	, "该用户不存在");
	    put(313	, "短信发送过于频繁，请稍后重试");
	    put(314	, "邮件发送过于频繁");
	    put(315	, "上传文件失败");
	    put(316	, "不支持的编码类型");
	    put(317	, "短信验证错误或者已经过有效期");
	    put(318	, "关联的地址过多，请删除部分重试");
	    put(319	, "关联的银行卡过多，请删除部分重试");
	    put(320	, "手机号码已注册");
	    put(321	, "尚未认证理财师身份");
	    put(322 , "邮件发送失败");
	    put(323 , "认证次数过多，请一个工作日后再申请认证");
	    put(324 , "未上传凭证");
	    put(325 , "您已预约参加该会议，请勿重复预约");
	    put(326 , "没有相关产品附件");
	    put(400	, "操作失败");//如果未指定错误类型默认返回错误。
	}};
	
	//private JsonEntity json = new JsonEntity(); 
	
	public class JsonEntity{
		private Integer status = 200;
		//反次返回的纪录总条数
		private Integer count;
		//页码
		private Integer pageindex;
		//总页数
		private Integer pagecount;
		private List<?> datas;
		private HashMap<?,?> data;
		private String message;
		public String toJson()	{
			//为避免系统的差异性，指定输出的日期格式
			Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
			return gson.toJson(this);
		}


		public int getStatus(){
			return this.status;
		}
		
		public void setPageIndex(int pageindex){
			this.pageindex = pageindex;
		}
		
		public int getPageIndex(){
			return this.pageindex;
		}
		
		public void setPageCount(int pagecount){
			this.pagecount = pagecount;
		}
		
		public int getPageCount(){
			return this.pagecount;
		}
		
		public void setCount(int count){
			this.count = count;
		}
		
		public int getCount(){
			if (this.count > 0) {
				return this.count;
			} else {
				return this.datas.size();
			}
		}
		
		public void setMessage(String message){
			this.message = message;
		}
		
		public String getMessage(){
			return this.message;
		}
		
		public void setDatas(List<?> datas){
			this.datas = datas;
		}
		//数组形式
		public List<?> getDatas(){
			return this.datas;
		}
		
		public void setData(HashMap<?, ?> data){
			this.data = data;
		}
		
		//map形式数据
		public HashMap<?, ?> getData(){
			return this.data;
		}
		
		//如果状态表里有对应的message信息，则会自动给message变量赋值
		public void setStatus(int status){
			this.status = status;
			if (returnMap.containsKey(status)) {
				this.setMessage(returnMap.get(status));
			} else {
				this.setMessage(returnMap.get(400));
			}
		}
		
		//返回json格式数据
		public void flush(HttpServletResponse response) {
			response.setHeader("Content-type", "application/json;charset=UTF-8");
			String output = this.toJson();

			try {
				response.getOutputStream().write(output.getBytes("UTF-8"));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	
	//实例化json对象
	public JsonEntity getJsonInstance() {
		return new JsonEntity();
	}
	
	public String FormatOrderCode(Integer orderId) {
		DateFormat fmt = new SimpleDateFormat("yyyyMMdd"); 
		return String.format("%s%08d", fmt.format(new java.util.Date()), orderId);
	}
}
