package com.tjk.comm;

import java.util.List;


import com.tjk.entity.ProductPerformance;

/*
 * 净值处理
 * 1、净值数据格式化
 * 2、同期上证指数对比及数据处理
 * */
public class FundsPerformance {
	/*
	 * 
	 * */
	public static List<ProductPerformance> getHS300(List<ProductPerformance> hslist, List<ProductPerformance> plist){
		List<ProductPerformance> newList = new java.util.ArrayList<ProductPerformance>();
		float base = 1;
		if (hslist.size() > 0) {
			base = hslist.get(0).getNetValue();
			base = base <= 0 ? 1: base;
		}
		for(ProductPerformance hs: hslist) {
			//取当前产品净值最新的沪深300净值，净值数据会重新折算成以第一天数值为基础的比值
			hs.setNetValue(1+(hs.getNetValue()-base)/base);
			newList.add(hs);
		}
		return newList;
	}

}
