package com.quant.controller;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.quant.dao.ProductTypeMapper;
import com.quant.entity.CommonSubclass;

@Controller
@RequestMapping("/operation/productType")
public class ProductTypeController extends BaseController {
	@Resource
	private ProductTypeMapper productTypeMapper;
	
	@RequestMapping("/findAllProductType.do")
	public String findAll(){
		return "product_type/product_type_list";
	}
	
	@RequestMapping("/findSimpleProductType.do")
	public String findSimpleProductType(Model model){
		List<CommonSubclass> productTypes = productTypeMapper.findSimpleProductType();
		model.addAttribute("productTypes", productTypes);
		return "product_type/product_type_list";
	}
	
	@RequestMapping("/toAddProductType.do")
	public String toAddProductType(){
		return "product_type/add_product_type";
	}
	@RequestMapping("/addProductType.do")
	public String addProductType(CommonSubclass commonSubclass){
		productTypeMapper.addProductType(commonSubclass);
		return "redirect:findSimpleProductType.do";
	}

}
