<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> 
<html>
	<head>
		<%@include file="/WEB-INF/navigation/JsAndCss.jsp" %>
		<script src="/js/html5.js"></script>
		<script type="text/javascript">
		  function deleteMeeting(meetingId){
		     var r = window.confirm("确定要删除此会议吗？");
                if(r){
                    location.href="deleteMeeting.do?meetingId="+meetingId ;
                }
		  }
		  function updateMeeting(meetingId){
		     location.href="toUpdateMeeting.do?meetingId="+meetingId;
		  }
		
		</script>
	</head>
	<body>
		<div class="container">
			<div class="navbar">
				<div class="navbar-inner">
					<%@include file="../navigation/menu.jsp" %>
				</div>
			</div>
			<div class="row">
				<%@include file="../navigation/navigation.jsp" %>
				<div class="span9">
					<h1>
						会议列表
					</h1>
					<table class="table table-bordered table-striped">
						<thead>
							<tr>
								<th>
									会议编号
								</th>
								<th>
									会议标题
								</th>
								<th>
									会议时间
								</th>
								<th>
									会议状态
								</th>
								<th>
									会议操作
								</th>
								
							</tr>
						</thead>
						<tbody>
							<c:forEach items="${meetings}" var="meeting">
							<tr>
								<td>
									${meeting.meetingId }
								</td>
								<td>
									${meeting.title }
								</td>
								<td>
									${meeting.openDate }
								</td>
								<td>
									<c:if test="${meeting.status==1 }">未召开</c:if>
									<c:if test="${meeting.status==2 }">召开中</c:if>
									<c:if test="${meeting.status==3 }">已召开</c:if>
								</td>
								<td>
									<input type="button" value="修改" onclick="updateMeeting(${meeting.meetingId })"/>&nbsp;&nbsp;
									<input type="button" value="删除" onclick="deleteMeeting(${meeting.meetingId })"/>
								</td>
								
							</tr>
							</c:forEach>
							<tr>
							<td colspan="5">
							<%@include file="../navigation/page.jsp"%>
							</td>
							</tr>
						</tbody>
					</table>
					<a class="toggle-link" href="toAddMeeting.do"><i class="icon-plus"></i>添加会议</a>
					
				</div>
			</div>
		</div>
	</body>
</html>
