package com.quant.controller;

import java.util.HashMap;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.quant.comm.ReadPro;
import com.quant.dao.CompanyMapper;
import com.quant.dao.OrderMapper;
import com.quant.dao.ProductMapper;
import com.quant.dao.SettingMapper;
import com.quant.dao.UserMapper;
import com.quant.entity.CommonSubclass;
import com.quant.entity.Company;
import com.quant.entity.User;
import com.quant.vo.OrderStatusVo;
import com.quant.vo.PageVo;
import com.quant.vo.UserPageVo;
import com.quant.vo.UserRelationVO;
import com.quant.entity.Tablefield;

@Controller
@RequestMapping("/operation/user")
@SessionAttributes("userPageVo")
public class UserController extends BaseController{

	@Resource
	private UserMapper userMapper;
	@Resource
	private ProductMapper productMapper;
	@Resource
	private SettingMapper settingMapper;
	@Resource 
	private CompanyMapper companyMapper;
	@Resource
	private ReadPro readPro;
	@Resource 
	private OrderMapper orderMapper;
	
	
	private HashMap<Integer, String> tablefield;
	
	private HashMap<Integer,String> tablefields;
	//存储分类中的title
	private HashMap<Integer,String> tableTitle;
	
	
	/**
	 * 分页查询用户信息
	 * @return
	 */
	@RequestMapping("/findUserByPage.do")
	public String listUser(UserPageVo pageVo,ModelMap map){
		Integer rows=userMapper.findRows(pageVo);
		pageVo.setRows(rows);
		List<User> list=userMapper.findUserByPage(pageVo);
		
		map.addAttribute("userPageVo", pageVo);
		map.put("users", list);
		map.addAttribute("userShowPages", pageVo.getShowPages());
		return "user/user_list";
	}
	/**
	 * 修改用户信息--中转控制层
	 * 跳转到修改用户信息页面
	 * @param uid
	 * @param map
	 * @return
	 */
	
	
	@RequestMapping("findBusinessCard.do")
	public String findBusinessCard(){
		return "";
	}
	
	@RequestMapping("toUpdateUser.do")
	public String toUpdateUser(Integer uid,ModelMap map){
		User user = userMapper.findUserByUid(uid);

		List<Company> list = companyMapper.findAllCompany();
		map.put("companies", list);

		List<CommonSubclass> education = settingMapper
				.findCommonSubclassByCategoryId(Integer.parseInt(readPro
						.readProperties("education")));

		map.addAttribute("user", user);
		map.put("education", education);
		map.put("companies", list);
		return "user/user_update";
	}
	/**
	 * 修改用户信息控制层
	 * @param user
	 * @param map
	 * @return
	 */
	@RequestMapping("/updateUser.do")
	public String updateUser(User user){
		if(user.getBirthday()==null||user.getBirthday()==""){
			user.setBirthday(null);
		}
		if(user.getRole()==2){
			user.setIsVerify(0);
		}else if(user.getIsVerify()==null){
			user.setIsVerify(0);
		}
		userMapper.updateUser(user);
		return "redirect:findUserByPage.do";
	}
	
	@RequestMapping("/findUserOrders.do")
	public String findUserOrder(PageVo pageVo,Model model){
		Integer rows = userMapper.findUserOrderRows();
		pageVo.setRows(rows);
		List<UserRelationVO> userOrders = userMapper.findUserOrder(pageVo);
		for(UserRelationVO user : userOrders){
			int id;
			if(user.getIntroducerUid()==null){
				if(user.getUid()!=null){
					id=user.getUid();
					String name =getTablefield(id);
					user.setSubmitterTitle(name);
				}else{
					user.setSubmitterTitle(user.getUserName());
				}
			}else{
				id=user.getIntroducerUid();
				String name =getTablefield(id);
				user.setSubmitterTitle(name);
			}
			
		}
		model.addAttribute("pageVo", pageVo);
		model.addAttribute("userOrders", userOrders);
		model.addAttribute("showPages", pageVo.getShowPages());
		return "user/user_order_list";
	}

	
	@RequestMapping("/toModifyUserOrder.do")
	public String toModifyUserOrder(Integer orderId,Model model){
		
		UserRelationVO userOrder = userMapper.findUserOrderById(orderId);
		Integer id,introducerUid;
		String name;
		id=userOrder.getUid();
		introducerUid = userOrder.getIntroducerUid();
		if(introducerUid!=null){
			name =getTablefield(introducerUid);
			userOrder.setSubmitterTitle(name);
		}else if(id!=null){
			name =getTablefield(id);
			userOrder.setSubmitterTitle(name);
		}else{
			userOrder.setSubmitterTitle("无");
		}
		UserRelationVO userOrderStatus = userMapper.findUserOrderStatusByOrderId(orderId);
		List<CommonSubclass> majorStatuses = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("majorStatus")));
		CommonSubclass majorStatus = settingMapper.findCommonSubclassBySubclassId(userOrder.getMajorStatus());
		CommonSubclass minorStatus = settingMapper.findCommonSubclassBySubclassId(userOrder.getMinorStatus());
		List<CommonSubclass> minorStatuses = settingMapper.findCommonSubclassByPid(userOrder.getMajorStatus());
		
		List<Company> company = companyMapper.findSimpleCompany();
		
		User user = userMapper.findUserByUid(userOrder.getIntroducerUid());
		
		
		//根据order_id查找所有订单状态
		List<OrderStatusVo> orderStatus=orderMapper.findStatusByOrderId(orderId); 
		for (OrderStatusVo orderStatusVo : orderStatus) {
			orderStatusVo.setMajorStatusName(getTitle(orderStatusVo.getMajorStatus()));
			orderStatusVo.setMinorStatusName(getTitle(orderStatusVo.getMinorStatus()));
		}
		
		model.addAttribute("user", user);
		model.addAttribute("company",company);
		model.addAttribute("orderStatus", orderStatus);
		model.addAttribute("userOrder", userOrder);
		model.addAttribute("userOrderStatus", userOrderStatus);
		model.addAttribute("majorStatuses", majorStatuses);
		model.addAttribute("majorStatus", majorStatus);
		model.addAttribute("minorStatus", minorStatus);
		model.addAttribute("minorStatuses", minorStatuses);
		
		return "user/update_user_order";
	}
	
	
	@RequestMapping("/modifyUserOrder.do")
	public String modifyUserOrder(UserRelationVO userOrder){
		if(userOrder.getMajorStatus()==1074){
			userOrder.setMinorStatus(userOrder.getMajorStatus());
		}
		
		userMapper.modifyUserAddress(userOrder);
		userMapper.modifyUserBankcard(userOrder);
		userMapper.modifyUserOrder(userOrder);
		userOrder.setDescription(userOrder.getStatusDescription());
		userMapper.addUserOrderStatus(userOrder);
		return "redirect:findUserOrders.do";
	}
	//删除订单主状态为预约的订单
	@RequestMapping("deleteUserOrder.do")
	public String deleteUserOrder(Integer orderId){
		userMapper.deleteUserOrder(orderId);
		userMapper.deleteOrderStatus(orderId);
		return "redirect:findUserOrders.do";
	}
	@RequestMapping(value="/findMinorStatusByMajorStatus.do",produces = "application/json")
	@ResponseBody
	public List<CommonSubclass> findMinorStatusByMajorStatus(Integer majorStatus){
		List<CommonSubclass> minorStatuses = settingMapper.findCommonSubclassByPid(majorStatus);
		return minorStatuses;
	}
	@RequestMapping(value="/findDescriptionByMinorStatus.do")
	@ResponseBody
	public CommonSubclass findDescriptionByMinorStatus(Integer minorStatus){
		CommonSubclass commonSubclass = settingMapper.findDescriptionByMinorStatus(minorStatus);
		return commonSubclass;
	}

	public String getTablefield(Integer key) {
		if (tablefield == null) {
			tablefield= new HashMap<Integer, String>();
			List<Tablefield> _list = tablefieldMapper.getName();
			for (Tablefield _f: _list) {
				tablefield.put(_f.getKey(), _f.getValue());
			}
		}
		if (tablefield.containsKey(key)) {
			return tablefield.get(key);
		} else {
			return "无";
		}
	}
	

	public String getTablefields(Integer key,Integer orderId) {
		if (tablefields == null) {
			tablefields= new HashMap<Integer, String>();
			List<Tablefield> _list = tablefieldMapper.getUri(orderId);
			for (Tablefield _f: _list) {
				tablefields.put(_f.getKey(), _f.getValue());
			}
		}
		if (tablefields.containsKey(key)) {
			return tablefields.get(key);
		} else {
			return "";
		}
	}
	
	//获得分类中的title
	public String getTitle(Integer key){
		if(tableTitle==null){
			tableTitle=new HashMap<Integer,String >();
			List<Tablefield> list=tablefieldMapper.getTablefield();
			for (Tablefield _f : list) {
				tableTitle.put(_f.getKey(), _f.getValue());
			}
		}
		if(tableTitle.containsKey(key)){
			return tableTitle.get(key);
		}else{
			return "N/A";
		}
	}
	
	@RequestMapping("/toUpdateUserOrderInvestor.do")
	public String toUpdateUserOrderInvestor(Integer orderId,Model model){
		List<UserRelationVO> user = userMapper.findByOrderId(orderId);
		UserRelationVO u = userMapper.findSingleByOrderId(orderId);
		for(UserRelationVO users : user){
			int id = users.getReserveId();
			if(id==1){
				String uri1 =users.getUri();
				model.addAttribute("uri1", uri1);
			}
			if(id==2){
				String uri2 = users.getUri();

				model.addAttribute("uri2", uri2);
			}
			if(id==3){
				String uri3 = users.getUri();

				model.addAttribute("uri3", uri3);
			}
			if(id==4){
				String uri4 = users.getUri();

				model.addAttribute("uri4", uri4);
			}
			if(id==5){
				String uri5 = users.getUri();

				model.addAttribute("uri5", uri5);
			}
		}
		model.addAttribute("orderId", orderId);
		model.addAttribute("u",u);
		return "user/update_user_order_investor";
	}
	
	@RequestMapping("/UpdateUserOrderInvestor.do")
	String UpdateUserOrderInvestor(UserRelationVO user){
		userMapper.updateOrderInvestorByOrderId(user);
		return "redirect:findUserOrders.do";
	}
	
	@RequestMapping("/userFeedbackList.do")
	public String userFeedbackList(Model model,PageVo pageVo){
		Integer rows = userMapper.findUserFeedbackRows();
		pageVo.setRows(rows);
		List<UserRelationVO> ufb = userMapper.findAllUserFeedbackByPage(pageVo);
		model.addAttribute("pageVo", pageVo);
		model.addAttribute("showPages",pageVo.getShowPages());
		model.addAttribute("ufb", ufb);
		return "user/user_feedback_list";
	}
	
	@RequestMapping("toReadUserFeedback.do")
	public String toread(Integer uid,Model model){
		UserRelationVO user = userMapper.findUserFeedbackByUid(uid);
		model.addAttribute("user", user);
		return "user/user_feedback_read";
	}
	
	@RequestMapping("findFinancial.do")
	@ResponseBody
	public List<User> findFinancial(Integer companyId){
		List<User> user= userMapper.findFinancialManagerByCompanyId(companyId);
		return user;
	}
	
	@RequestMapping("checkMobile.do")
	@ResponseBody
	public boolean checkMobile(String checkMobile){
		List<User> user = userMapper.findAll();
		boolean flag =false;
		for(User users : user){
			String mobile = users.getMobile();
			if(mobile.equals(checkMobile)){
				flag=true;
				break;
			}else{
				flag=false;
			}
		}
		return flag;
	}
}
