package com.quant.controller;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.quant.dao.FavoriteMapper;
import com.quant.entity.Favorite;
import com.quant.vo.FavoritePageVo;
import com.quant.vo.ManagerRelationVO;
import com.quant.vo.PageVo;

@Controller
@RequestMapping("/operation/favorite")
public class FavoriteController {
	@Resource
	private FavoriteMapper fMapper;
	
	@RequestMapping("/findFavorite.do")
	public String findFavorite(Model model,FavoritePageVo pageVo){
		Integer rows=fMapper.findRows(pageVo);
		pageVo.setRows(rows);
		List<Favorite> favorite = fMapper.findFavoriteByPage(pageVo);
		model.addAttribute("favorite", favorite);
		model.addAttribute("pageVo",pageVo);
		model.addAttribute("showPages", pageVo.getShowPages());
		return "user/user_collect_list";
	}

}
