package com.quant.controller;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.quant.dao.AttachmentMapper;
import com.quant.dao.ProductMapper;
import com.quant.entity.Attachment;
import com.quant.vo.PageVo;

@Controller
@RequestMapping("/operation/attachmentManage")
public class AttachmentController extends BaseController{
	@Resource
	private ProductMapper productMapper;
	@Resource 
	private AttachmentMapper attachmentMapper;
	
	@RequestMapping("listAttachment.do")
	public String toAttachment(Model model,PageVo pageVo){
		Integer rows = productMapper.findAttachmentRows();
		pageVo.setRows(rows);
		List<Attachment> attachment = productMapper.findAllAttachment(pageVo);
		model.addAttribute("pageVo",pageVo);
		model.addAttribute("showPages", pageVo.getShowPages());
		model.addAttribute("attachment", attachment);
		return "attachment/attachment_list";
	}
	
	@RequestMapping("deleteAttachment.do")
	public String deleteAttachment(Integer id){
		productMapper.deleteAttachmentById(id);
		return "redirect:listAttachment.do";
	}
	
	@RequestMapping("updateAttachment.do")
	public String updateAttachment(Attachment attachment,String attachmentTitle){
		attachment.setTitle(attachmentTitle);
		productMapper.updateAttachmentById(attachment);
		return "redirect:listAttachment.do";
	}
	
	@RequestMapping("toUpdateAttachment.do")
	public String toUpdateAttachment(Integer id,Model model){
		Attachment attachment = productMapper.findAttachmentById(id);
		model.addAttribute("attachment", attachment);
		return "attachment/attachment_update";
	}
	//附件上传页面中转控制层
	@RequestMapping("toUploadAttachment.do")
	public String toUploadAttachment(){
		return "attachment/attachment_upload";
	}
	//附件上传
	@RequestMapping("uploadAttachment.do")
	public String uploadAttachment(Attachment atta){
		if(atta!=null){
			if(atta.getAttachmentType()!=2){
				atta.setUri("/"+atta.getUri());
			}
			attachmentMapper.addAttachment(atta);
		}
		return "redirect:listAttachment.do";
	}
	//附件下载
	@RequestMapping("download.do")
	@ResponseBody
	public HttpServletResponse downloadAttachment(HttpServletRequest request,HttpServletResponse response,Integer attachmentId ){
		Attachment atta=attachmentMapper.findAttachmentById(attachmentId);
		if(atta!=null){
			try {
				String path = "";
				String temp = request.getServletContext().getRealPath("");
				temp = temp.substring(0, temp.lastIndexOf("\\") + 1);
				if(atta.getAttachmentType()==2){
					path=temp+"/"+atta.getUri();
				}else{
					path=temp+atta.getUri();
				}
				// path是指欲下载的文件的路径。
				File file = new File(path);
				String fileName = file.getName();
				// 取得文件的后缀名。
				String ext = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase();
				// 以流的形式下载文件。
				InputStream fis = new BufferedInputStream(new FileInputStream(path));
				byte[] buffer = new byte[fis.available()];
				fis.read(buffer);
				fis.close();
				// 清空response
				response.reset();
				// 设置response的Header
				response.addHeader("Content-Disposition","attachment;filename="+ new String(fileName.getBytes()));
				response.addHeader("Content-Length", "" + file.length());
				OutputStream toClient = new BufferedOutputStream(response.getOutputStream());
				response.setContentType("application/octet-stream");
				toClient.write(buffer);
				toClient.flush();
				toClient.close();
			} catch (IOException ex) {
				ex.printStackTrace();
				try {
					response.sendError(404, "文件不存在");
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}else{
			try {
				response.sendError(404,  "文件不存在");
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
        return response;
	}
	
}
