<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8" %>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<!--[if lt IE 7 ]><html lang="en" class="ie6 ielt7 ielt8 ielt9"><![endif]--><!--[if IE 7 ]><html lang="en" class="ie7 ielt8 ielt9"><![endif]--><!--[if IE 8 ]><html lang="en" class="ie8 ielt9"><![endif]--><!--[if IE 9 ]><html lang="en" class="ie9"> <![endif]--><!--[if (gt IE 9)|!(IE)]><!--> 
<html lang="en"><!--<![endif]--> 
	<head>
		<%@include file="/WEB-INF/navigation/JsAndCss.jsp" %>
	</head>
	<body>
		<div class="container">
			<div class="navbar">
				<div class="navbar-inner">
					<%@include file="../navigation/menu.jsp"%>
				</div>
			</div>
			<div class="row">
				<%@include file="../navigation/navigation.jsp"%>
				<div class="span9">
					<form method="post" action="updateSubclass.do">
						<fieldset>
						   <legend>编辑${subclass.title}</legend>
							<div class="control-group">
							<input name="subclassId" value="${subclass.subclassId}" type="hidden"/>
							<input name="categoryId" value="${subclass.categoryId}" type="hidden"/>
								<label class="control-label" for="input01">类别名称</label>
								<div class="controls">
									<input type="text" class="input-xlarge" id="input01" name="title" value="${subclass.title}"/>
								</div>
							</div>
							<div class="control-group">
								<label class="control-label" for="select01">父类型</label>
								<div class="controls">
								 <select id="select01" name="pid"> <option value="">-- 选择类型 --</option> 
									<c:forEach items="${subclasses}" var="s">
									  <option value="${s.subclassId}" <c:if test="${s.subclassId==subclass.pid}">selected</c:if>
									  >${s.title}</option>
									</c:forEach>
									</select> 
									
								</div>
							</div>
							<div class="control-group">
								<label class="control-label" for="textarea">说明</label>
								<div class="controls">
									<textarea class="input-xlarge" id="textarea" rows="5" name="description">${subclass.description}</textarea>
								</div>
							</div>
							<div class="control-group">
								<label class="control-label" for="input02">是否有效</label>
								<div class="controls">
									<input type="checkbox" class="input-xlarge" id="input02" name="status" value="1"
									<c:if test="${subclass.status==1}">checked</c:if>
									/>
								</div>
							</div>
							<div class="control-group">
								<label class="control-label" for="input03">排序ID</label>
								<div class="controls">
									<input type="text" class="input-xlarge" id="input03" name="sortId" value="${subclass.sortId}" />
								</div>
							</div>
							<div >
								<input type="submit" value="确定"/>&nbsp;&nbsp;
								<input type="button" value="取消" onclick="history.back();"/>
							</div>
						</fieldset>
					</form>
				</div>
			</div>
		</div>
	</body>
</html>