<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<%@include file="/WEB-INF/navigation/JsAndCss.jsp" %>
		<link href="/css/glDatePicker.default.css" rel="stylesheet" />
		<script src="/js/html5.js"></script>
		<script src="/datePicker/WdatePicker.js"></script>
		<script type="" src="/js/ajaxfileupload.js"></script>
		<script type="text/javascript">
		 $.getUrlParam = function(name)
			{
			var r = window.location.search.split('=')[1];
			if (r!=null) return r; return null;
			}

			function checkExpectedProfit(){
				var reg = /^[1-9]\d*|0$/;
				var expectedProfit = $("#expectedProfit").val();
				if(!reg.test(expectedProfit)){
					$("#expectedProfit").val(0);
				}else{
					$("#expectedProfit").val(expectedProfit*1000)
				}
			}

			function deleteAttachment(id){
				var r = window.confirm("确定要删除此附件吗?");
				if(r){
					location.href="deleteAttachment.do?id="+id;
				}
			}
			
			function ajaxFileUpload() {  
	            $.ajaxFileUpload  
	        (  
	            {  
	                url: '/AttachmentUp.jsp',  
	                secureuri: false,  
	                fileElementId:'uriFile',  
	                dataType: 'json',  
	                beforeSend: function() {  
	                    $("#loading").show();  
	                },  
	                complete: function() {  
	                    $("#loading").hide();  
	                },  
	                success: function(data, status) {  
	                        $('#uri').val("/"+data.url);
	                        var orginUri=data.physicalPath;
							var t = data.originalName;
							var size= data.size;
							var title=t.substring(0,t.lastIndexOf("."));
							$.ajax({
		                    	url:"uplodeAttachment.do",
		                    	type:"post",
		                    	data:{uri:data.url,title:title,relationId:$.getUrlParam('relationId'),orginUri:orginUri,size:size},
		                    	success:function(data){
		                    		if(data==200||data=="200"){
		                    			location.href="toProductAttachment.do?relationId="+$.getUrlParam('relationId');
		                    		}
		                    	}
		                    });
	                },  
	                error: function(data, status, e) {  
	                    alert(e);  
	                }  
	            }  
	        );
	            return false;  
	        }  
</script>
</head>
<body>
	<div class="container">
		<div class="navbar">
			<div class="navbar-inner">
				<%@include file="../navigation/menu.jsp"%>
			</div>
		</div>
		<div class="row">
			<%@include file="../navigation/navigation.jsp"%>
			<div class="span9">
				<h1>产品附件列表</h1>
				<table class="table table-bordered table-striped">
					<thead>
						<tr>
							<th>附件说明</th>
							<th>上传时间</th>
							<th>文件大小 单位：MB</th>
							<th>下载链接</th>
							<th>操作</th>
						</tr>
					</thead>
					<tbody>
						<c:forEach items="${attachment}" var="attachment">
							<tr>
								<td>${attachment.title}</td>
								<td>
								<fmt:formatDate value="${attachment.postTime}"  pattern="yyyy-MM-dd HH:mm:ss"/>
								</td>
								<td>
								<fmt:formatNumber value="${attachment.size/1024}" maxFractionDigits="2"/>
								</td>
								<td>/${attachment.uri}</td>
								<td class="td_modi">
									<input type="button" value="删除" onclick="deleteAttachment(${attachment.id})"/>
								</td>
							</tr>
						</c:forEach>
					</tbody>
				</table>
				<div class="control-group">
								<label class="control-label" for="uri">上传附件</label>
								<div class="controls">
											<input id="uriFile" type="file" name="uriFile" class="fimg1"/>
											<input id="uri" type="hidden" name="uri" />
											<button type="button" class="btn btn-primary" onclick="return ajaxFileUpload();">上传</button>
								</div>
							</div>
							<div>
								<input class="btn" type="button" onclick="history.back()" value="返回"/>
							</div>
			</div>
		</div>
	</div>
</body>
</html>