<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8" %>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<!DOCTYPE html>
<!--[if lt IE 7 ]><html lang="en" class="ie6 ielt7 ielt8 ielt9"><![endif]--><!--[if IE 7 ]><html lang="en" class="ie7 ielt8 ielt9"><![endif]--><!--[if IE 8 ]><html lang="en" class="ie8 ielt9"><![endif]--><!--[if IE 9 ]><html lang="en" class="ie9"> <![endif]--><!--[if (gt IE 9)|!(IE)]><!--> 
<html lang="en"><!--<![endif]--> 
	<head>
		<%@include file="/WEB-INF/navigation/JsAndCss.jsp" %>
		<style type="text/css">
		.current_page{border:solid 1px;padding:0 3px;}
		</style>
		<!--[if lt IE 9]><script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script><![endif]-->
		<script type="text/javascript">
		function getNewsType(){
			var newsType=$("#select1").val();
			$.post(
					"findNewsTypeByPid.do",
					{"newsType":newsType},
					function(data){
						var obj = document.form.select2;
						obj.length=1;
						if(data != null&&data!=""){	
							$('#select2').show();
							for(i=0;i<data.length;i++){							
							obj[i+1]=new Option(data[i].title, data[i].subclassId);
						}
					}else {
				   		$('#select2').hide();
					}
				});
			}
		
		
		
		  function deleteNews(newsId){
		     var r = window.confirm("确定要删除此资讯？");
                if(r){
                    location.href="deleteNews.do?newsId="+newsId ;
                }
		  }
		  function updateNews(newsId){
		     location.href="toUpdateNews.do?newsId="+newsId;
		  }
		  
		function checkTitle(){
			$.ajax({
				url:"checkTitle.do",
				data:{checkTitle:$("#checktitle").val()},
				type:"post",
				success:function(data){
					$("#result").val(data.msg);
				}
			});
		}
		</script>
		
	</head>
	<body>
		<div class="container">
			<div class="navbar">
				<div class="navbar-inner">
					<%@include file="../navigation/menu.jsp"%>
				</div>
			</div>
			<div class="row">
				<%@include file="../navigation/navigation.jsp"%>
				<div class="span9">
					<h3>
						资讯列表
					</h3>
					<form action="listNews.do" name="form" method="post">
					<div class="control-group">
								<label class="control-label" for="select1">父类型</label>
								<div class="controls">
								 <select style="width:130px" id="select1" name="first" onchange="getNewsType()"> <option value="0">-- 选择类型 --</option> 
									<c:forEach items="${newsType}" var="t">
									  <option value="${t.subclassId}" <c:if test="${t.subclassId==newsPageVo.first}" >
									  		selected
									  </c:if>
									  >${t.title}</option>
									</c:forEach>
									</select> 
									<select style="width:150px" id="select2" name="second"> 
										<option value="0">-- 选择子类 型 --</option>
									<c:forEach items="${type}" var="type">
										<option value="${type.subclassId}"  
										<c:if test="${type.subclassId==newsPageVo.second}">selected</c:if>>
										${type.title}
										</option>
									</c:forEach>
									</select> 
									<input type="text" name="checkTitle" id="checkTitle" value="${newsPageVo.checkTitle}"/>
									<input type="submit" value="搜索"/>
								</div>
							</div>
					</form>
					 	
					<table class="table table-bordered table-striped">
						<thead>
							<tr>
								<th>
									标题
								</th>
								<th>
									分类
								</th>
								<th>
									发布时间
								</th>
								<th>
									操作
								</th>
								
							</tr>
						</thead>
						<tbody>
							<c:forEach items="${news}" var="n">
							<tr>
								<td>
								${n.title}
								<c:if test="${n.rmd!=0}">
									<img style="width:20px;" src="../../img/duigou.png"/>
								</c:if>
								</td>
								<td>
									<c:forEach items="${types}" var="tp">
									  <c:if test="${n.newsType==tp.key}">${tp.value}</c:if>
									</c:forEach>
								</td>
								<td>
									<fmt:formatDate value="${n.pubTime}" pattern="yyyy-MM-dd"/>
								</td>
								<td>
									<input type="button" value="修改" onclick="updateNews(${n.newsId})"/>&nbsp;&nbsp;
									<input type="button" value="删除" onclick="deleteNews(${n.newsId})"/>
								</td>
								
							</tr>
							</c:forEach>
							<tr>
							<td colspan="5">
												<c:if test="${newsPageVo.currentPage<=1}">
	<a href="javascript:;">上一页</a>
</c:if>
<c:if test="${newsPageVo.currentPage>1}">
	<a href="?currentPage=${newsPageVo.currentPage-1}">上一页</a>
</c:if>

<c:forEach items="${newsPageVo.showPages }" var="showPages">
	<c:choose>
		<c:when test="${showPages==newsPageVo.currentPage }">
			<span class="current_page">${newsPageVo.currentPage }</span>
		</c:when>
		<c:otherwise>
	        <a href="?currentPage=${showPages}">${showPages }</a>
		</c:otherwise>
	</c:choose>
</c:forEach>

<c:if test="${newsPageVo.currentPage>=newsPageVo.totalPage}">
	<a href="javascript:;">下一页</a>
</c:if>
<c:if test="${newsPageVo.currentPage<newsPageVo.totalPage}">
	<a href="?currentPage=${newsPageVo.currentPage+1}">下一页</a>
</c:if>

<span>共${newsPageVo.rows }条，共${newsPageVo.totalPage }页</span>

							</td>
							</tr>
						</tbody>
					</table>
				</div>	
			</div>
		</div>
	</body>
</html>
