<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<!--[if lt IE 7 ]><html lang="en" class="ie6 ielt7 ielt8 ielt9"><![endif]-->
<!--[if IE 7 ]><html lang="en" class="ie7 ielt8 ielt9"><![endif]-->
<!--[if IE 8 ]><html lang="en" class="ie8 ielt9"><![endif]-->
<!--[if IE 9 ]><html lang="en" class="ie9"> <![endif]-->
<!--[if (gt IE 9)|!(IE)]><!-->
<html lang="en">
<!--<![endif]-->
<head>
<%@include file="/WEB-INF/navigation/JsAndCss.jsp" %>
<script type="text/javascript" src="/datePicker/WdatePicker.js"></script>
<link href="${path }/css/glDatePicker.default.css">
<script type="text/javascript">
  function getCompanyName(){
	 var companyName= $("select[name='companyId']  option:selected").text();
	 $("input[name=companyName]").val(companyName);
  }
  function view(obj){
	  src=obj.src;
	  window.open(src,"查看大图");
  }
</script>
</head>
<body>
	<div class="container">
		<div class="navbar">
			<div class="navbar-inner">
				<%@include file="../navigation/menu.jsp"%>
			</div>
		</div>
		<div class="row">
			<%@include file="../navigation/navigation.jsp"%>
			<div class="span9">
				<form method="post" action="UpdateFinancialManager.do">
					<fieldset>
						<legend>编辑理财师信息</legend>
						<div class="control-group">
						<input  name="uid" value="${userVerify.uid}" type="hidden"/>
						<label class="control-label" for="input00">姓名</label>
							<input  id="input00" name="name" value="${userVerify.name}" type="text" /> 
							<label class="control-label" for="input01">手机号码</label>
							<div class="controls">
								<input  type="text" class="input-xlarge" id="input01"
									name="mobile" value="${userVerify.mobile}" />
							</div>
						</div>
                        <div class="control-group">
						<label class="control-label" for="input0">所属公司 <br/>*选择不了,请填写公司名</label>
							<div class="controls">
							    <select name="companyId" onchange="getCompanyName();">
							        <option value="0">--选择公司--</option>
							        <c:forEach items="${company}" var="c">
							          <option value="${c.companyId}"
							          <c:if test="${c.companyId==userVerify.companyId}">selected</c:if>>${c.companyName}</option>
							        </c:forEach>
							    </select>
								<input  type="text" class="input-xlarge" id="input0"
									name="companyName" value="${userVerify.companyName}" />
							</div>
						</div>
						<div class="control-group">
								<label class="control-label" for="status">是否认证</label>
									<div class="controls">
										<select  id="status" name="status">
											<option <c:if test="${userVerify.status==0}">selected</c:if> value="0">未审核</option>
											<option <c:if test="${userVerify.status==1}">selected</c:if> value="1">已审核</option>
											<option <c:if test="${userVerify.status==2}">selected</c:if> value="2">审核不通过</option>
										</select>
									</div>
							</div>
							<div class="control-group">
						<label class="control-label" for="input0">未通过理由</label>
							<div class="controls">
								<input  type="text" class="input-xlarge" id="reasonStatus"
									name="reasonStatus" value="${userVerify.reasonStatus}" />
							</div>
						</div>
						<div class="control-group">
								<label class="control-label" for="fileInput">名片</label>
									<div class="controls">
									<c:choose>
										<c:when test="${userVerify.cardUri!=null&&user.cardUri!=''}">
											<img src="/${userVerify.cardUri}" onclick="view(this);" />
										</c:when>
										<c:otherwise>
											尚未上传名片
										</c:otherwise>
									</c:choose>
									</div>
							</div>
							<div class="controls">
								<input type="submit" class="input-xlarge" value="确定"/>
							</div>
					</fieldset>
				</form>
			</div>
		</div>
	</div>
	
</body>
</html>