package com.quant.interceptor;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import com.quant.comm.LoginSecret;
import com.quant.comm.ReadPro;
@Component
public class CheckLoginInterceptor implements HandlerInterceptor {
	@Resource
	private ReadPro readPro;
	// 请求结束时调用
		public void afterCompletion(HttpServletRequest arg0,
				HttpServletResponse arg1, Object arg2, Exception arg3)
				throws Exception {
		}
		// Controller业务方法执行后调用
		public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1,
				Object arg2, ModelAndView arg3) throws Exception {

		}

		// Controller业务方法执行钱调用
		public boolean preHandle(HttpServletRequest request,
				HttpServletResponse response, Object obj) throws Exception {
			// 从cookie中读取用户信息
			String extra = readPro.readProperties("password");
			String _ids = LoginSecret.getCookie(request, response, "_ids");
			String _tss = LoginSecret.getCookie(request, response, "_tss");
			String tokens = LoginSecret.getCookie(request, response, "tokens");
			boolean flag = LoginSecret.checkCookie(_ids, _tss, extra, tokens);
			if (!flag) {
				response.sendRedirect(
						"/operation/admin/toLoginCheck.do");

				
				return false;
			}
			return true;
		}
}
