package com.quant.dao;

import java.util.List;

import com.quant.annotation.MyBatisRepository;
import com.quant.entity.User;
import com.quant.vo.PageVo;
import com.quant.vo.UserPageVo;
import com.quant.vo.UserRelationVO;

@MyBatisRepository
public interface UserMapper {
	//分页查询
	Integer findRows(UserPageVo pageVo);
	List<User> findUserByPage(UserPageVo pageVo);
	//添加用户
	void addUser(User user);
	//根据uid查询用户
	User findUserByUid(Integer uid);
	//修改用户信息
	void updateUser(User user);
	
	
	
	List<UserRelationVO> findUserOrder(PageVo pageVo);
	Integer findUserOrderRows();
	UserRelationVO findUserOrderById(Integer id);
	void modifyUserOrder(UserRelationVO userOrder);
	void addUserOrderStatus(UserRelationVO userOrderStatus);
	UserRelationVO findUserOrderStatusByOrderId(Integer id);
	
	 List<UserRelationVO>findFinancialManagerByRole(PageVo pageVo);
	Integer findFinancialManagerRows();
	
	List<User> findBusinessCardById(); 
	UserRelationVO findFinancialManagerByUid(Integer uid);
	List<UserRelationVO> findByOrderId(Integer orderId);
	void updateOrderInvestorByOrderId(UserRelationVO user);
	UserRelationVO findSingleByOrderId(Integer orderId);
	
	void modifyUserAddress(UserRelationVO userOrder);
	void modifyUserBankcard(UserRelationVO userOrder);

	
	List<UserRelationVO> findAllUserFeedbackByPage(PageVo pageVo);
	UserRelationVO findUserFeedbackByUid(Integer uid);
	Integer findUserFeedbackRows();

	List<User> findFinancialManagerByCompanyId(Integer companyId);
	

	//删除订单主状态为预约的订单
	void deleteUserOrder(Integer orderId);
	//删除相应的订单状态
	void deleteOrderStatus(Integer orderId);
	
	//查找到所有的用户的信息
	List<User> findAll();

}
