package com.quant.dao;

import java.util.List;

import com.quant.annotation.MyBatisRepository;
import com.quant.entity.Attachment;
import com.quant.entity.ManagerProduct;
import com.quant.entity.ProductBasic;
import com.quant.entity.ProductCommission;
import com.quant.entity.ProductDescription;
import com.quant.vo.PageVo;
import com.quant.vo.ProductPageVo;
import com.quant.vo.ProductRelationVO;
import com.quant.entity.ProductPerformance;
import com.quant.vo.ProductQueryVo;


@MyBatisRepository
public interface ProductMapper extends Mapper  {
	List<ProductBasic> findAllProduct();
	int addProductBasic(ProductRelationVO obj);
	void addProductIssue(ProductRelationVO obj);
	void addProductSubscribe(ProductRelationVO obj);
	void addProductPerformance(ProductRelationVO obj);
	
	//返回单只产品的发行信息
	ProductRelationVO getProductIssue(Integer productId);
	//反回单只产品的认购信息
	ProductRelationVO getProductSubscribe(Integer productId);
	
	void modifyProductBasic(ProductRelationVO obj);
	void modifyProductIssue(ProductRelationVO obj);
	void modifyProductSubscribe(ProductRelationVO obj);
	void modifyProductPerformance(ProductRelationVO obj);
	void modifyManagerProduct(ManagerProduct mp);
	
	Integer findMaxSortIdByProductId();
	void addProductCommission(ProductCommission obj);
	void addProductDescription(ProductDescription obj);
	void modifyProductCommission(ProductCommission obj);
	void modifyProductDescription(ProductDescription obj);
	List<ProductCommission> findProductCommission(Integer productId);
	ProductDescription findProductDescriptionByProductId(Integer productId);
	ProductCommission findProductCommissionByAmount(ProductCommission productCommission);
	int deleteProductCommission(Integer id);
	
	List<ProductBasic> findSimpleProduct();
	void addManagerProduct(ManagerProduct managerProduct);
	void modifyProduct(ProductRelationVO product);
	
	ProductRelationVO findProductPerformanceByExpiryDate(ProductRelationVO product);
	List<ProductRelationVO> findProductPerformance(Integer productId);
	//修改产品排序
	int modifySort(ProductBasic productBasic);
	
	//用于企业网站
	List<ProductRelationVO> findNewestProduct();
	List<ProductRelationVO> findClassicProduct();
	
	//查看单只基金净值信息
		List<ProductPerformance> getProductPerformance(ProductQueryVo vo);
		//查看指定日期当天及之后的所有的沪深300指数数据
		List<ProductPerformance> getHSPerformance(java.util.Date expiryDate);
	
	//2015/02/13晚上新增，用于宽客官方网站
    List<ProductBasic> findSameTypeProductByProductId(Integer productId);
    List<ProductBasic> findProductByProductType(Integer productType);
    List<ProductBasic> findProductByCompanyId(int companyId);
    ProductRelationVO findProductByProductId(Integer productId);
    ProductRelationVO findLastProductByCompanyId(int companyId);
    ProductRelationVO findHotfundsByProductId(int productId);
    List<ProductBasic> findHotfundsByCompanyId(int companyId);
    ProductRelationVO findLastHotfundstByCompanyId(int companyId);
	
	
	//分页查询
    Integer findRows(ProductPageVo pageVo);
    List<ProductBasic> findSimpleProductByPage(ProductPageVo pageVo);
    
    //用于附件
    List<Attachment> findAllAttachment(PageVo pageVo);
    Integer findAttachmentRows();
    List<Attachment> findAttachmentByRelationId(Integer relationId);
    void deleteAttachmentById(Integer id);
    void deleteAttachmentByRelationId(Integer id);
    void addAttachment(Attachment attachment);
    Integer findRelationIdById(Integer id);
    void updateAttachmentByrelationId(Attachment attachment);
	void updateAttachmentById(Attachment attachment);
	Attachment findAttachmentById(Integer id);
	
	
}
