package com.quant.controller;

import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.quant.dao.CompanyMapper;
import com.quant.dao.FinancialManagerMapper;
import com.quant.dao.UserMapper;
import com.quant.entity.Company;
import com.quant.entity.User;
import com.quant.entity.UserVerify;
import com.quant.vo.FinanManagerPageVo;
import com.quant.vo.PageVo;
import com.quant.vo.UserRelationVO;

@Controller
@RequestMapping("/operation/financialManager")
public class FinancialManagerController extends BaseController {
	
	@Resource
	private FinancialManagerMapper financialManagerMapper;
	
	@Resource
	private UserMapper userMapper;
	
	@Resource
	private CompanyMapper companyMapper;
	
	
	@RequestMapping("findFinancialManager.do")
	public String findFinancialManager(Model model,PageVo pageVo){
		Integer rows =financialManagerMapper.findFinancialManagerRows();
		pageVo.setRows(rows);
		model.addAttribute("pageVo", pageVo);
		model.addAttribute("showPages", pageVo.getShowPages());
		List<UserRelationVO> userVerify = userMapper.findFinancialManagerByRole(pageVo);
		model.addAttribute("userVerify", userVerify);
		return "financialManager/financialManager_list";
	}
	
	@RequestMapping("toReadFinancialManager.do")
	public String toReadFinancialManager(Model model,Integer uid){
		UserRelationVO userVerify =userMapper.findFinancialManagerByUid(uid);
		model.addAttribute("userVerify",userVerify);
		return "financialManager/financialManager_read";
	}
	
	@RequestMapping("toApproveFinancialManager.do")
	public String toApproveFinancialManager(Model model,FinanManagerPageVo  fpageVo){
		Integer rows=financialManagerMapper.findApproveFinancialManagerRows(fpageVo);
		fpageVo.setRows(rows);
		model.addAttribute("pageVo", fpageVo);
		model.addAttribute("showPages", fpageVo.getShowPages());
		List<UserVerify> userVerify = financialManagerMapper.findFinancialManagerByPage(fpageVo);
		model.addAttribute("userVerify", userVerify);
		return "financialManager/approveFinancialManager_list";
	}
	
	@RequestMapping("toUpdateFinancialManager.do")
	public String toUpdateFinancialManagerByUid(Model model,Integer uid,HttpServletRequest request){
		UserVerify userVerify = financialManagerMapper.findFinancialManagerByUid(uid);
		List<Company> list=companyMapper.findAllCompany();
		model.addAttribute("userVerify", userVerify);
		model.addAttribute("company", list);
		return "financialManager/financialManager_update";
	}
	
	@RequestMapping("UpdateFinancialManager.do")
	public String UpdateFinancialManager(Model model, UserVerify userVerify,
			FinanManagerPageVo pageVo) {
		User user = userMapper.findUserByUid(userVerify.getUid());
		if(user!=null){
		if (userVerify.getStatus() == 1) {
			user.setIsVerify(1);
			user.setRole(1);

			user.setName(userVerify.getName());
			user.setMobile(userVerify.getMobile());

			Integer maxId = companyMapper.findMaxCompanyId();
			// 判断所属公司
			Company company = companyMapper.findCompanyById(userVerify.getCompanyId());
			if (company == null) {
				company = new Company();
				company.setCompanyName(userVerify.getCompanyName());
				company.setShorterName(userVerify.getCompanyName());
				company.setCompanyId(maxId + 1);
				company.setIsPartner(0);
				companyMapper.addCompany(company);
				companyMapper.modifyCompany(company);
				user.setCompanyId(maxId + 1);
				userVerify.setCompanyId(maxId + 1);
			}else{
				user.setCompanyId(company.getCompanyId());
			}
		} else if(userVerify.getStatus()==2){
			user.setIsVerify(0);
			user.setRole(2);
		}
		userMapper.updateUser(user);
		financialManagerMapper.UpdateFinancialManagerByUid(userVerify);
		}
		Integer rows = financialManagerMapper
				.findApproveFinancialManagerRows(pageVo);
		pageVo.setRows(rows);
		model.addAttribute("pageVo", pageVo);
		model.addAttribute("showPages", pageVo.getShowPages());
		List<UserVerify> uv = financialManagerMapper
				.findFinancialManagerByPage(pageVo);
		model.addAttribute("userVerify", uv);
		return "financialManager/approveFinancialManager_list";
	}
}
