<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<!--[if lt IE 7 ]><html lang="en" class="ie6 ielt7 ielt8 ielt9"><![endif]-->
<!--[if IE 7 ]><html lang="en" class="ie7 ielt8 ielt9"><![endif]-->
<!--[if IE 8 ]><html lang="en" class="ie8 ielt9"><![endif]-->
<!--[if IE 9 ]><html lang="en" class="ie9"> <![endif]-->
<!--[if (gt IE 9)|!(IE)]><!-->
<html lang="en">
<!--<![endif]-->
<head>
<%@include file="/WEB-INF/navigation/JsAndCss.jsp"%>
<style type="text/css">
.current_page {
	border: solid 1px;
	padding: 0 3px;
}
</style>
</head>
<body>
	<div class="container">
		<div class="navbar">
			<div class="navbar-inner">
				<%@include file="../navigation/menu.jsp"%>
			</div>
		</div>
		<div class="row">
			<%@include file="../navigation/navigation.jsp"%>
			<div class="span9">
				<h1>分类管理</h1>
				<table class="table table-bordered table-striped">
					<thead>
						<tr>
							<th>ID</th>
							<th>所属类别</th>
							<th>类别名称</th>
							<th>类别描述</th>
							<th>操作</th>
						</tr>
					</thead>
					<tbody>
						<c:forEach items="${subclass}" var="s">
							<tr>
								<td>${s.subclassId}</td>
								<td>${title}</td>
								<td>${s.title}</td>
								<td>${s.description}</td>
								<td><a
									href="toUpdateSubclass.do?subclassId=${s.subclassId}&categoryId=${categoryId}">编辑</a>&nbsp;&nbsp;
									<a href="toListSubclass.do?pid=${s.subclassId}">查看</a></td>
							</tr>
						</c:forEach>
						<tr>
							<td colspan="5">
								<c:if test="${subclassPageVo.currentPage<=1}">
									<a href="javascript:;">上一页</a>
								</c:if> <c:if test="${subclassPageVo.currentPage>1}">
									<a href="?currentPage=${subclassPageVo.currentPage-1}&categoryId=${categoryId}">上一页</a>
								</c:if> 
								<c:forEach items="${showPages }" var="showPages">
									<c:choose>
										<c:when test="${showPages==subclassPageVo.currentPage }">
											<span class="current_page">${subclassPageVo.currentPage }</span>
										</c:when>
										<c:otherwise>
											<a href="?currentPage=${showPages }&categoryId=${categoryId}">${showPages }</a>
										</c:otherwise>
									</c:choose>
								</c:forEach> 
								<c:if test="${subclassPageVo.currentPage>=subclassPageVo.totalPage}">
									<a href="javascript:;">下一页</a>
								</c:if> 
								<c:if test="${subclassPageVo.currentPage<subclassPageVo.totalPage}">
									<a href="?currentPage=${subclassPageVo.currentPage+1}&categoryId=${categoryId}">下一页</a>
								</c:if> <span>共${subclassPageVo.rows }条，共${subclassPageVo.totalPage }页</span>



							</td>
						</tr>
						<tr>
							<td colspan="5"><input type="button" value="新增分类"
								onclick="location.href='toAddSubclass.do?categoryId=${categoryId}'" /></td>
						</tr>
					</tbody>
				</table>

			</div>
		</div>
	</div>
</body>
</html>