<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> 
<html>
	<head>
		<%@include file="/WEB-INF/navigation/JsAndCss.jsp" %>
	</head>
	<body>
		<div class="container">
			<div class="navbar">
				<div class="navbar-inner">
					<%@include file="../navigation/menu.jsp" %>
				</div>
			</div>
			<div class="row">
				<%@include file="../navigation/navigation.jsp" %>
				<div class="span9">
					<h1>
						编辑预约
					</h1>
					
					<form id="new-project" class="form-horizontal" action="modifyMeetingRegist.do?id=${meeting.id }" method="post">
						<fieldset>
						<legend></legend>
							<div class="control-group">
								<label class="control-label" for="input01">预约人</label>
								<div class="controls">
									<input type="text" class="input-xlarge" id="input01" name="name" value="${meeting.name }" />
								</div>
							</div>
							<div class="control-group">
								<label class="control-label" for="input01">联系方式(手机)</label>
								<div class="controls">
									<input type="text" class="input-xlarge" id="input01" name="mobile" value="${meeting.mobile }" />
								</div>
							</div>
							<div class="control-group">
								<label class="control-label" for="input01">联系方式(固话)</label>
								<div class="controls">
									<input type="text" class="input-xlarge" id="input01" name="telphone" value="${meeting.telphone }" />
								</div>
							</div>
							<div class="control-group">
								<label class="control-label" for="input01">邮箱</label>
								<div class="controls">
									<input type="text" class="input-xlarge" id="input01" name="email" value="${meeting.email }" />
								</div>
							</div>
							<div class="control-group">
								<label class="control-label" for="input01">公司名</label>
								<div class="controls">
									<input type="text" class="input-xlarge" id="input01" name="companyName" value="${meeting.companyName }" />
								</div>
							</div>
							<div class="control-group">
								<label class="control-label" for="input01">职务</label>
								<div class="controls">
									<input type="text" class="input-xlarge" id="input01" name="position" value="${meeting.position }" />
								</div>
							</div>
							<div class="control-group">
								<label class="control-label" for="textarea">补充说明</label>
								<div class="controls">
									<textarea class="input-xlarge" id="textarea" rows="3" name="description">${meeting.description }</textarea>
								</div>
							</div>
							<div class="control-group">
								<label class="control-label" for="input01">报名时间</label>
								<div class="controls">
									<input type="text" class="input-xlarge" id="input01" name="pubTime" value="<fmt:formatDate value="${meeting.pubTime }" pattern="yyyy-MM-dd"/>" readonly="readonly" />
								</div>
							</div>
							<div class="control-group">
							<label class="control-label" for="status">报名状态</label>
							<div class="controls">
								<select name="status" id="status">
								<option value="1" <c:if test="${meeting.status==1 }">selected</c:if> >已报名</option>
								<option value="2" <c:if test="${meeting.status==2 }">selected</c:if> >报名失败</option>
								</select>
							</div>
						</div>
							<div class="form-actions">
								<button type="submit" class="btn btn-primary">保存</button> <button class="btn" type="reset" onclick="history.back()">取消</button>
							</div>
						</fieldset>
					</form>
				</div>
			</div>
		</div>
	</body>
</html>
