<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> 
<html>
	<head>
		<%@include file="/WEB-INF/navigation/JsAndCss.jsp" %>
		<script src="/js/html5.js"></script>
		<script type="text/javascript">
		  function deleteMeetingRegist(id){
		     var r = window.confirm("确定要删除此预约吗？");
                if(r){
                    location.href="deleteMeetingRegist.do?id="+id ;
                }
		  }
		  function updateMeetingRegist(id){
		     location.href="toUpdateMeetingRegist.do?id="+id;
		  }
		
		</script>
	</head>
	<body>
		<div class="container">
			<div class="navbar">
				<div class="navbar-inner">
					<%@include file="../navigation/menu.jsp" %>
				</div>
			</div>
			<div class="row">
				<%@include file="../navigation/navigation.jsp" %>
				<div class="span9">
					<h1>
						会议列表
					</h1>
					<table class="table table-bordered table-striped">
						<thead>
							<tr>
								<th>
									预约编号
								</th>
								<th>
									预约人
								</th>
								<th>
									会议标题
								</th>
								<th>
									预约时间
								</th>
								<th>
									预约状态
								</th>
								<th>
									预约操作
								</th>
								
							</tr>
						</thead>
						<tbody>
							<c:forEach items="${meetingRegists}" var="meeting">
							<tr>
								<td>
									${meeting.id }
								</td>
								<td>
									${meeting.name }
								</td>
								<td>
									${meeting.title }
								</td>
								<td>
									<fmt:formatDate value="${meeting.pubTime }" pattern="yyyy-MM-dd"/>
								</td>
								<td>
									<c:if test="${meeting.status==1 }">已报名</c:if>
									<c:if test="${meeting.status==2 }">报名失败</c:if>
								</td>
								<td>
									<input type="button" value="修改" onclick="updateMeetingRegist(${meeting.id })"/>&nbsp;&nbsp;
									<input type="button" value="删除" onclick="deleteMeetingRegist(${meeting.id })"/>
								</td>
								
							</tr>
							</c:forEach>
							<tr>
							<td colspan="6">
							<%@include file="../navigation/page.jsp"%>
							</td>
							</tr>
						</tbody>
					</table>
					
				</div>
			</div>
		</div>
	</body>
</html>
