<%@page contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="shortcut icon" href="/website/images/favicon.ico" type="image/x-icon">
<title>产品预约--宽客资本</title>
<link rel="stylesheet" type="text/css" href="/website/css/kkcss.css" />
<script type="text/javascript" src="/website/js/jquery.js"></script>
<script type="text/javascript" src="/website/js/menu.js"></script>
 <script language="javascript" type="text/javascript">
		 	function check_userName(){
		 		var userName = $("#userName").val();
		 		if(userName==""){
		 			$("#userName_msg").text("用户名不能为空");
		 			return false;
		 		}
		 		var reg =/[\u4E00-\u9FA5]{1,50}/;
		 		if(!reg.test(userName)){
		 			$("#userName_msg").text("用户名格式不正确");
		 			return false;
		 		}
		 		$("#userName_msg").text("有效的用户名");
		 		return true;
		 	}
		 	
		 	function check_mobile(){
		 		var mobile= $("#mobile").val();
		 		if(mobile==""){
		 			$("#mobile_msg").text("电话号码不能为空");
		 			return false;
		 		}
		 		var reg =/^(13[0-9]|14[5|7]|15[0|1|2|3|5|6|7|8|9]|18[0|1|2|3|5|6|7|8|9])\d{8}$/;
		 		if(!reg.test(mobile)){
		 			$("#mobile_msg").text("电话号码格式不正确");
		 			return false;
		 		}
		 		$("#mobile_msg").text("有效的电话号码");
		 		return true;
		 	}
		 	
		 	function check_orderMount(){
		 		reg = /^[1-9]{0,}[.]{0,1}[0-9]{0,}$/;
		 		var mount = $("#orderMount").val();
		 		if(!reg.test(mount)){
		 			$("#orderMount_msg").text("请正确输入金额");
		 			return false;
		 		}
		 		if(mount==null||!mount){
		 			$("#orderMount_msg").text("不能为空");
					return false;
		 		}
		 		orderMount = parseFloat(mount);
		 		if(orderMount<100||orderMount>5000){
					$("#orderMount_msg").text("输入金额范围100万-5000万");
					return false;
		 		}else{
		 			$("#orderMount_msg").text("有效金额");
		 			return true;
		 		}
		 	}
		 	
		 	function check(){
		 		var flag=true;
		 		flag=check_orderMount();
		 		if(flag){
		 			flag=check_userName();
		 			if(flag){
		 				flag=check_mobile();
		 				if(flag){
		 					form.submit();
		 					return;
		 				}
		 			}
		 		}
		 		alert("请正确填写相关信息");
		 		
		 	
		 	}
 </script>
</head>
<body>
<div class="subhead">
  <%@include file="../navigation/menu.jsp" %>
</div>
<div class="mainbox clear">
  <%@include file="../navigation/productmenu.jsp" %>
  <div class="right fr">
    <div class="reservebox">
      <div class="newcon">
        <b>重要提示：</b><br />
      <p>证券投资具有一定风险，根据《中华人民共和国信证券投资基金法》、《私募投资基金监督管理暂行办法》及《私募投资基金管理人登记和基金备案办法（试行）》及其他相关法律法规的有关规定，参与信托计划的人士应为风险识别、评估、承受能力较强的合格投资者。请确认您或您所代表的机构是一名“合格投资者”， 并将遵守适用的有关法规。本网站所载的各种信息和数据等仅供参考，并不构成广告或销售要约，或买入任何证券、基金或其它投资工具的建议。投资者应仔细审阅相关金融产品的合同文件等以了解其风险因素，或寻求专业的投资顾问的建议。</p>
 <br/><p>私募基金产品净值可能会有较大的波动，并可能在短时间內大幅下跌，并造成投资者损失部分或全部投资金额。您应确保有关投资產品适合您的需要。如有怀疑，请咨询按中国内地法规注册的专业分析师的意见，並要求其确认有关投资产品适合並符合您的投资目标。</p>
 <br/><p>投资产品的价格及其收益存在涨跌变动，而过往的产品业绩数据并不预示其未来的表现，投资者不应依赖本网站所提供的数据做出投资决策，否则由投资者自行承担所有风险。</p>

      </div>
      <form id="form" action="/product/order_submit.do" method = "post">
      <div class="forminfo clear">
        <dl>
          <dt>客户基本信息</dt>
          <dd class="clear">
            <span>客户类型：</span>
            <label><input name="type" type="radio" value="" checked="checked" />个人客户</label>
            <label><input name="type" type="radio" value="" />机构客户</label>
          </dd>
          <dd class="clear"><span>客户名称：</span><input name="userName" type="text" class="intext" id="userName"
          										placeholder="1-50的中文字"
          										onblur="check_userName();"/>
          					<div  class="password_msg_long" id="userName_msg"></div>
          										</dd>         
          <dd class="clear"><span>手机号码：</span><input name="mobile" type="text" class="intext" id="mobile"
          										onblur="check_mobile();"/>
          					<div  class="password_msg_long" id="mobile_msg"></div>
          										</dd>
        </dl>
        <dl>
          <dt>预约产品信息</dt>
          <dd class="clear">
            <span>产品名称：</span>
            <select name="productId">
            <c:forEach items="${productList}" var="pitem">
          	<option value = "${pitem.productId}" <c:if test="${pitem.productId == productId }"> selected="selected"</c:if> >- ${pitem.productName}</option>
         	</c:forEach>
            </select>
          </dd>
          <dd class="clear"><span>预约金额(万元)：</span><input name="orderMount" type="text" class="intext" id="orderMount" 
          												placeholder="金额为100万-5000万之间"
          											 onblur="check_orderMount();"/>
          											<div  class="password_msg_long" id="orderMount_msg"></div>
          											</dd>
        </dl>
        <p class="pbtns"><input name="" type="button" value="提交" class="tjbtn" onclick="check();" />
        				 <input name="" type="reset" class="czbtn" /></p>
      </div>
      </form>
    </div>
  </div>
</div>
<div class="footer">
  <%@include file="../navigation/footer.jsp" %>
</div>
</body>
</html>