package com.quant.test;

import java.util.List;

import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.quant.dao.SettingMapper;
import com.quant.entity.CommonCategory;
import com.quant.entity.CommonSubclass;

public class TestSettingCase {
	String config="applicationContext.xml";
	ApplicationContext ac=new ClassPathXmlApplicationContext(config);
	@Test
	public void testAddCategory(){
		SettingMapper settingMapper=ac.getBean(SettingMapper.class);
		CommonCategory category=new CommonCategory();
		category.setTitle("公司");
		category.setDescription("提供基金产品的公司");
		category.setStatus(1);
		category.setMultiHierarchy(1);
		Integer maxId=settingMapper.findCategoryMaxId();
		category.setCategoryId(maxId+1);
		settingMapper.addCategory(category);
		System.out.println(category.getId()+" "+category.getCategoryId());
	}
	@Test
	public void testUpdateCategory(){
		SettingMapper settingMapper=ac.getBean(SettingMapper.class);
		CommonCategory category=new CommonCategory();
		category.setCategoryId(1);
		category.setDescription("资讯");
		settingMapper.updateCategory(category);
	}
	
	@Test
	public void testFindSetting(){
		SettingMapper settingMapper=ac.getBean(SettingMapper.class);
		List<CommonCategory> list=settingMapper.findAll();
		for (CommonCategory commonCategory : list) {
			System.out.println(commonCategory.getTitle()+" "+commonCategory.getCategoryId());
		}
	}
	@Test
	public void findSubclass(){
		SettingMapper settingMapper=ac.getBean(SettingMapper.class);
		List<CommonSubclass> list=settingMapper.findSubclassByPid(1);
		for (CommonSubclass commonSubclass : list) {
			System.out.println(commonSubclass.getTitle()+" "+ commonSubclass.getCategoryId());
		}
	}
	
}
