package com.quant.dao;

import java.util.List;

import com.quant.annotation.MyBatisRepository;
import com.quant.entity.Sms;
import com.quant.vo.PageVo;

@MyBatisRepository
public interface SmsMapper {
	List<Sms> findAll();

	void add(Sms sms);

	List<Sms> findByStatus(int status);
	//获取该手机最近30分钟的该号码的短信
	List<Sms> findAllByMobile(String mobile);
	//获取该手机最近30分钟的该号码的短信
	List<Sms> findLastByMobile(String mobile);
	
	//获取该用户最近30分钟的该号码的短信
	List<Sms> findAllByUid(int uid);
	//获取该用户最近30分钟的该号码的短信
	List<Sms> findLastByUid(int uid);
	
	List<Sms> findSmsByPage(PageVo pageVo);
	
	int updateById(Sms sms);
	
	Sms findById(int id);
	//删除短信--即修改短信status
	void deleteById(int id);
	
	int findRows();
}
