package com.quant.dao;

import java.util.List;

import com.quant.annotation.MyBatisRepository;
import com.quant.entity.CommonCategory;
import com.quant.entity.CommonSubclass;
import com.quant.vo.PageVo;
import com.quant.vo.SubclassPageVo;

@MyBatisRepository
public interface SettingMapper {
	//查看所有类--category
	List<CommonCategory> findAll();
	//根据categoryId查看子类--subclass
	List<CommonSubclass> findSubclassByCategoryId(Integer categoryId);
	//根据pid查看子类--subclass
	List<CommonSubclass> findSubclassByPid(Integer pid);
	//根据categoryId查找category
	CommonCategory findCategoryByCategoryId(Integer categoryId);
	//修改category
	void updateCategory(CommonCategory category);
	//增加分类--category
	void addCategory(CommonCategory category);
	//查找categoryId最大值
	Integer findCategoryMaxId();
	//跟据categoryId查找title
	String findTitleByCategoryId(Integer categoryId);
	//跟据subclassId查找subclass
	CommonSubclass findSubclassBySubclassId(Integer subclassId);
	//查看所有子类--subclass
	List<CommonSubclass> findAllSubclass();
	//修改分类--subclass
	void updateSubclass(CommonSubclass subclass);
	//增加分类--subclass
	void addSubclass(CommonSubclass subclass);
	//查找行数--category
	Integer findRows();
	//分页查找category
	List<CommonCategory> findCategoryByPage(PageVo pageVo);
	//查找subclassId最大值
	Integer findSubclassMaxId();
	//查找父类为bull的subclass
	List<CommonSubclass> findSubclassByCategoryIdWherePidIsNull(Integer categoryId);
	//查找行数--subclass
	Integer findSubclassRows(Integer categoryId);
	//分页查找subclass
	List<CommonSubclass> findSubclassByCategoryIdAndPage(SubclassPageVo pageVo);
	
	List<CommonSubclass> findCommonSubclassByCategoryId(Integer id);
	List<CommonSubclass> findCommonSubclassByPid(Integer id);
	
	
	CommonSubclass findCommonSubclassBySubclassId(Integer id);
	CommonSubclass findDescriptionByMinorStatus(Integer minorStatus);


}
