package com.quant.dao;

import java.util.List;

import com.quant.annotation.MyBatisRepository;
import com.quant.entity.CommonSubclass;
import com.quant.entity.News;
import com.quant.vo.NewsPageVo;

@MyBatisRepository
public interface NewsMapper {
	//查看资讯
	List<News> findNews();
	//通过标题查找资讯
	List<News> findNewsByTitle(String title);
	//查找资讯类别
	List<CommonSubclass> findNewsTypesByCategoryId(Integer categoryId);
    //添加资讯
	void addNews(News news);
	//
	int findRows();
	//
	List<News> findNewsByPage(NewsPageVo pageVo);
	//
	void updateNews(News news);
	//
	News findNewsByNewsId(Integer newsId);
	//
	void deleteNews(Integer newsId);
	//
	Integer findNewsMaxId();
	
	Integer findRowsByNewsPageVo(NewsPageVo pageVo);
	
	CommonSubclass findNewsTypeNameByNewsType(Integer newsType);
	
	List<String> findAllTitle();
	List<News> findThirtyBestNews();
	List<News> findThirtyMoreNews();
}
