package com.quant.dao;

import java.util.List;

import com.quant.annotation.MyBatisRepository;
import com.quant.entity.Meeting;
import com.quant.entity.MeetingRegist;
import com.quant.vo.MeetingPageVo;

@MyBatisRepository
public interface MeetingMapper {
	//会议
	int findMeetingRows(MeetingPageVo pageVo);
	List<Meeting> findMeetingByPage(MeetingPageVo pageVo);
	Meeting findMeetingByMeetingId(int meetingId);
	int deleteMeeting(int meetingId);
	int modifyMeeting(Meeting meeting);
	int addMeeting(Meeting meeting);
	Integer findMaxMeetingId();
	
	//会议报名
	List<MeetingRegist> findByPage(MeetingPageVo pageVo);
	int modifyMeetingRegist(MeetingRegist mr);
	int deleteMeetingRegist(Integer id);
	int findRows(MeetingPageVo pageVo);
	MeetingRegist findMeetingRegistById(Integer id);
}
